@extends($activeTemplate . 'restaurant.layouts.master')
@section('content')
    <div class="py-70">
        <div class="container">
            <div class="row justify-content-center mt-2">
                <div class="col-lg-12 ">
                    <div class="dashboard-table">
                        <div class="dashbaord-table-header">
                            <h6 class="card-header__title mb-0">@lang('Logs') <i
                                    class="las la-file-invoice-dollar text--base"></i></h6>
                            <div>
                                <div class="d-flex justify-content-end mb-1">
                                    @php echo authRestaurant()->reviewStars @endphp
                                </div>
                                <small>@lang('Average Rating')</small>
                            </div>
                        </div>

                        <table class="table table--responsive--xl">
                            <thead>
                                <tr>
                                    <th>@lang('User')</th>
                                    <th class="text-center">@lang('Stars')</th>
                                    <th class="text-center">@lang('Review')</th>
                                    <th class="text-center">@lang('Reviewed at')</th>
                                    <th class="text-end">@lang('Action')</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($reviews as $review)
                                    <tr>
                                        <td>
                                            {{ __($review->user->fullname) }}
                                        </td>
                                        <td class="text-center">
                                            <div>
                                                @for ($i = 0; $i < $review->rating; $i++)
                                                    <i class="las la-star active"></i>
                                                @endfor
                                                @for ($i = 0; $i < 5 - $review->rating; $i++)
                                                    <i class="las la-star"></i>
                                                @endfor
                                            </div>
                                        </td>
                                        <td class="text-center">
                                            {{ strLimit(__($review->review), 20) }}
                                        </td>

                                        <td>
                                            {{ diffForHumans($review->updated_at) }}
                                        </td>
                                        <td>
                                            <button class="btn btn--sm btn--base detailBtn"
                                                data-review="{{ __($review->review) }}">
                                                <i class="la la-desktop"></i>
                                            </button>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td class="text-muted empty-message" colspan="100%">{{ __($emptyMessage) }}</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                    <div class="mt-3">
                        @if ($reviews->hasPages())
                            {{ paginateLinks($reviews) }}
                        @endif
                    </div>

                </div>
            </div>
        </div>
    </div>



    <div id="detailModal" class="modal fade" tabindex="-1" role="dialog">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">@lang('Review')</h5>
                    <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                        <i class="las la-times"></i>
                    </button>
                </div>
                <div class="modal-body">
                    <p class="review-message"></p>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-dark btn--sm" data-bs-dismiss="modal">@lang('Close')</button>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('script')
    <script>
        (function($) {
            "use strict";
            $('.detailBtn').on('click', function() {
                var modal = $('#detailModal');
                var review = $(this).data('review');
                modal.find('.review-message').text(review);
                modal.modal('show');
            });
        })(jQuery);
    </script>
@endpush
