@extends($activeTemplate . 'restaurant.layouts.master')
@section('content')
    <div class="container py-70">
        <div class="row justify-content-center">
            <div class="col-md-12">
                <div class="card custom--card">
                    <div class="card-body">
                        <form method="POST" enctype="multipart/form-data">
                            @csrf

                            <!-- Restaurant Information -->
                            <h5 class="mb-4">@lang('Restaurant Information') <i class="las la-hamburger text--base"></i></h5>
                            <div class="row">
                                <div class="form-group col-sm-12">
                                    <label class="form-label">@lang('Restaurant Name')</label>
                                    <input type="text" class="form-control form--control" name="restaurant_name"
                                        value="{{ @$restaurant->restaurant_name }}" required readonly>
                                </div>
                            </div>
                            <div class="row">
                                <div class="form-group col-sm-6">
                                    <label class="form-label">@lang('E-mail Address')</label>
                                    <input class="form-control form--control" value="{{ $restaurant->email }}" readonly>
                                </div>
                                <div class="form-group col-sm-6">
                                    <label class="form-label">@lang('Mobile Number')</label>
                                    <input class="form-control form--control" value="{{ $restaurant->mobile }}" readonly>
                                </div>
                            </div>

                            <!-- Address Information -->
                            <h5 class="mt-5 mb-4">@lang('Address Information') <i class="las la-map-marker-alt text--base"></i></h5>
                            <div class="row">
                                <div class="form-group col-sm-6">
                                    <label class="form-label">@lang('Address')</label>
                                    <input type="text" class="form-control form--control" name="address"
                                        value="{{ @$restaurant->address }}">
                                </div>
                                <div class="form-group col-sm-6">
                                    <label class="form-label">@lang('State')</label>
                                    <input type="text" class="form-control form--control" name="state"
                                        value="{{ @$restaurant->state }}">
                                </div>
                            </div>
                            <div class="row">
                                <div class="form-group col-sm-4">
                                    <label class="form-label">@lang('Zip Code')</label>
                                    <input type="text" class="form-control form--control" name="zip"
                                        value="{{ @$restaurant->zip }}">
                                </div>
                                <div class="form-group col-sm-4">
                                    <label class="form-label">@lang('City')</label>
                                    <input type="text" class="form-control form--control" name="city"
                                        value="{{ @$restaurant->city }}">
                                </div>
                                <div class="form-group col-sm-4">
                                    <label class="form-label" for="location">@lang('Location')</label>
                                    <select id="location" name="location"
                                        class="form-select form-control form--control select2-basic" required>
                                        @foreach ($locations as $location)
                                            <option value="{{ $location->id }}"
                                                {{ old('location', @$restaurant->location_id) == $location->id ? 'selected' : '' }}>
                                                {{ __($location->name) }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>

                            <!-- Media Uploads -->
                            <h5 class="mt-5 mb-4">@lang('Media Uploads') <i class="las la-image text--base"></i></h5>
                            <div class="row">
                                <div class="form-group col-12">
                                    <label>
                                        @lang('Cover Image')
                                        <i class="las la-info-circle" data-toggle="tooltip" title="@lang('Upload a cover image for your restaurant. This image will be displayed at the top of your restaurant details page.')"></i>
                                    </label>
                                    <x-image-uploader image="{{ @$restaurant->cover_image }}" class="w-100"
                                        type="restaurantCover" :required="false" id="restaurantCover" name="cover_image" />
                                </div>
                                <div class="form-group col-sm-6">
                                    <label>
                                        @lang('Thumbnail Image')
                                        <i class="las la-info-circle" data-toggle="tooltip" title="@lang('Upload a thumbnail image that represents your restaurant in listings and previews.')"></i>
                                    </label>
                                    <x-image-uploader image="{{ @$restaurant->cover_image_thumb }}" class="w-100"
                                        type="restaurantCoverThumb" :required="false" id="restaurantCoverThumb"
                                        name="cover_image_thumb" />
                                </div>
                                <div class="form-group col-sm-6">
                                    <label>
                                        @lang('Profile Image')
                                        <i class="las la-info-circle" data-toggle="tooltip" title="@lang('Upload a profile image for your restaurant, typically a restaurant logo.')"></i>
                                    </label>
                                    <x-image-uploader image="{{ @$restaurant->profile_image }}" class="w-100"
                                        type="restaurantProfile" :required="false" id="restaurantProfile"
                                        name="profile_image" />
                                </div>

                            </div>

                            <!-- Submit Button -->
                            <div class="form-group mb-0">
                                <button type="submit" class="btn btn--base w-100">@lang('Submit')</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
