@extends($activeTemplate . 'restaurant.layouts.master')
@section('content')
    <div class="container py-70">
        <div class="row justify-content-center gy-4">
            @foreach ($plans as $plan)
                <div class="col-xl-4 col-sm-6">
                    <div class="card-item">
                        <div class="card-item__header">
                            <span class="card-header__icon">
                                <i class="fas fa-cube"></i>
                            </span>
                            <span class="card-header__text"> {{ __($plan->name) }} </span>
                        </div>
                        <div class="card-item__body">
                            <h4 class="card-item__price">{{ showAmount($plan->price) }}</h4>
                            <p class="card-item__time">
                                <span class="card-item__time-icon"><i class="far fa-clock"></i></span>
                                @lang('Time'): <span class="text--danger">{{ $plan->time }}@lang('days')</span>
                            </p>
                            <button type="submit" class="btn btn--base w-100 mt-2 confirmationBtn"
                                data-question="{{ __('Are you sure to purchase this plan ' . $plan->name) }}?"
                                data-action="{{ route('restaurant.plan.purchase', $plan->id) }}"
                                @if (!isPlanExpired($plan)) disabled @endif>@lang('Purchase')</button>
                        </div>
                    </div>
                </div>
            @endforeach
        </div>
    </div>

    <x-confirmation-modal />
@endsection
