<div class="sidebar-menu flex-between">
    <div class="sidebar-menu__inner">
        <span class="sidebar-menu__close d-lg-none d-block"><i class="las la-times"></i></span>
        <div class="sidebar-logo">
            <a href="{{ route('restaurant.home') }}" class="sidebar-logo__link"><img src="{{ siteLogo('dark') }}"
                    alt="img not found"></a>
        </div>

        <ul class="sidebar-menu-list">
            <li class="sidebar-menu-list__item {{ menuActive('restaurant.home') }}">
                <a href="{{ route('restaurant.home') }}" class="sidebar-menu-list__link">
                    <span class="icon"><i class="las la-home"></i></span>
                    <span class="text">@lang('Dashboard')</span>
                </a>
            </li>

            <li class="sidebar-submenu-list__item {{ menuActive('restaurant.categories') }}">
                <a href="{{ route('restaurant.categories') }}" class="sidebar-menu-list__link">
                    <span class="icon"><i class="las la-tags"></i></span>
                    <span class="text">@lang('Category')</span>
                </a>
            </li>

            <li class="sidebar-menu-list__item has-dropdown {{ menuActive('restaurant.food*') }}">
                <a href="javascript:void(0)" class="sidebar-menu-list__link">
                    <span class="icon"><i class="las la-hamburger"></i></span>
                    <span class="text">@lang('Food')</span>
                </a>
                <div class="sidebar-submenu" @php echo menuActive('restaurant.food*',4) @endphp>
                    <ul class="sidebar-submenu-list">
                        <li class="sidebar-submenu-list__item {{ menuActive('restaurant.food.index') }}">
                            <a href="{{ route('restaurant.food.index') }}" class="sidebar-submenu-list__link">
                                <span class="text">@lang('All Foods')</span>
                            </a>
                        </li>

                        <li class="sidebar-submenu-list__item {{ menuActive('restaurant.food.overview') }}">
                            <a href="{{ route('restaurant.food.overview') }}" class="sidebar-submenu-list__link">
                                <span class="text">@lang('Add Food')</span>
                            </a>
                        </li>
                    </ul>
                </div>
            </li>

            <li class="sidebar-menu-list__item has-dropdown {{ menuActive('restaurant.order*') }}">
                <a href="javascript:void(0)" class="sidebar-menu-list__link">
                    <span class="icon"><i class="las la-file-invoice"></i></span>
                    <span class="text">@lang('Orders')</span>
                    @if (@$ordersActiveCount)
                        <span class="menu-badge pill bg--danger ms-auto">
                            <span class="notify-text">{{ @$ordersActiveCount }}</span>
                        </span>
                    @endif
                </a>
                </a>
                <div class="sidebar-submenu" @php echo menuActive('restaurant.order*',4) @endphp>
                    <ul class="sidebar-submenu-list">
                        
                         <li class="sidebar-submenu-list__item {{ menuActive('restaurant.order.processing') }}">
                            <a href="{{ route('restaurant.order.processing') }}" class="sidebar-submenu-list__link">
                                <span class="text">@lang('Processing Orders')</span>
                                
                            </a>
                        </li>


                        <li class="sidebar-submenu-list__item {{ menuActive('restaurant.order.active') }}">
                            <a href="{{ route('restaurant.order.active') }}" class="sidebar-submenu-list__link">
                                <span class="text">@lang('Active Orders')</span>
                                <span class="notify-text">{{ @$ordersActiveCount }}</span>
                            </a>
                        </li>

                       
                        <li class="sidebar-submenu-list__item {{ menuActive('restaurant.order.on.delivery') }}">
                            <a href="{{ route('restaurant.order.on.delivery') }}" class="sidebar-submenu-list__link">
                                <span class="text">@lang('On Delivery Orders')</span>
                            </a>
                        </li>

                       

                        <li class="sidebar-submenu-list__item {{ menuActive('restaurant.order.completed') }}">
                            <a href="{{ route('restaurant.order.completed') }}" class="sidebar-submenu-list__link">
                                <span class="text">@lang('Completed Orders')</span>
                            </a>
                        </li>


                        <li class="sidebar-submenu-list__item {{ menuActive('restaurant.order.cancelled') }}">
                            <a href="{{ route('restaurant.order.cancelled') }}" class="sidebar-submenu-list__link">
                                <span class="text">@lang('Cancelled Orders')</span>
                            </a>
                        </li>
                        <li class="sidebar-submenu-list__item {{ menuActive('restaurant.order.index') }}">
                            <a href="{{ route('restaurant.order.index') }}" class="sidebar-submenu-list__link">
                                <span class="text">@lang('All Orders')</span>
                            </a>
                        </li>

                    </ul>
                </div>
            </li>

            <li class="sidebar-menu-list__item {{ menuActive('restaurant.reviews') }}">
                <a href="{{ route('restaurant.reviews') }}" class="sidebar-menu-list__link">
                    <span class="icon"><i class="las la-star"></i></span>
                    <span class="text">@lang('Reviews')</span>
                </a>
            </li>

            <li class="sidebar-menu-list__item {{ menuActive('restaurant.delivery.setting') }}">
                <a href="{{ route('restaurant.delivery.setting') }}" class="sidebar-menu-list__link">
                    <span class="icon"><i class="las la-shopping-cart"></i></span>
                    <span class="text">@lang('Delivery')</span>
                </a>
            </li>

            <li class="sidebar-menu-list__item has-dropdown {{ menuActive('restaurant.deposit.*') }}">
                <a href="javascript:void(0)" class="sidebar-menu-list__link">
                    <span class="icon"><i class="las la-file-invoice-dollar"></i></span>
                    <span class="text">@lang('Deposit')</span>
                </a>
                <div class="sidebar-submenu" @php echo menuActive('restaurant.deposit.*',4) @endphp>
                    <ul class="sidebar-submenu-list">
                        <li class="sidebar-submenu-list__item {{ menuActive('restaurant.deposit.index') }}">
                            <a href="{{ route('restaurant.deposit.index') }}" class="sidebar-submenu-list__link">
                                <span class="text">@lang('Deposit Now')</span>
                            </a>
                        </li>
                        <li class="sidebar-submenu-list__item {{ menuActive('restaurant.deposit.history') }}">
                            <a href="{{ route('restaurant.deposit.history') }}" class="sidebar-submenu-list__link">
                                <span class="text">@lang('Deposit History')</span>
                            </a>
                        </li>
                    </ul>
                </div>
            </li>

            

            <li class="sidebar-menu-list__item {{ menuActive('restaurant.transactions') }}">
                <a href="{{ route('restaurant.transactions') }}" class="sidebar-menu-list__link">
                    <span class="icon"><i class="las la-file-invoice-dollar"></i></span>
                    <span class="text">@lang('Transactions')</span>
                </a>
            </li>

            <li class="sidebar-menu-list__item">
                <a href="{{ route('restaurant.logout') }}" class="sidebar-menu-list__link">
                    <span class="icon"><i class="las la-sign-out-alt"></i></span>
                    <span class="text">@lang('Logout')</span>
                </a>
            </li>
        </ul>
    </div>

</div>
