@extends($activeTemplate . 'restaurant.layouts.master')
@section('content')
    <section class="refund">
        <div class="container">
            <div class="row gy-4 justify-content-center">
                <div class="col-xl-7 col-lg-7 col-md-10">
                    <div class="card custom--card refund-section">
                        <div class="refund-fund d-flex justify-content-between">
                            <div class="refund-fund-left">
                                <span>@lang('Total Price')</span>
                                <h4 class="refund-fund-title">
                                    {{ showAmount($order->total_price) }}
                                </h4>
                                <br>
                                <h4 class="refund-fund-title">
                                    {{ __($order->user->fullname) }}<br>
                                        رقم الطلب: {{ $order->id }}<br>
                                   رقم الموبايل: {{ $order->user->mobile }}
                                </h4>

                            </div>
                            <div class="refund-fund-icon">
                                <a href=""><i class="fas fa-cog"></i></a>
                            </div>
                        </div>
                        <div class="refund-order">
                            <h4><i class="fas fa-receipt"></i>@lang('Order Items') @if ($order->status == Status::ORDER_CANCELLED)
                                    <span class="text--danger">(@lang('Cancelled'))</span>
                                @endif
                            </h4>
                        </div>
                        @php $subTotal = 0; @endphp
                        @foreach ($order->items as $key => $item)
                            @php $subTotal = $subTotal + $item->total_price; @endphp
                            <div class="accordion custom--accordion" id="accordionExample{{ 'accordionItem' . $key }}">
                                <div class="accordion-item">
                                    <div class="accordion-header" id="headingOne{{ 'accordionItem' . $key }}">
                                        <div class="accordion-button" data-bs-toggle="collapse"
                                            data-bs-target="#collapseOne{{ 'accordionItem' . $key }}" aria-expanded="true"
                                            aria-controls="collapseOne{{ 'accordionItem' . $key }}">
                                            <div class="refund-according">
                                                <span>{{ showDateTime($item->created_at) }}</span>
                                            </div>
                                            <div class="refund-according">
                                                <h4>{{ __($item->food->name) }}</h4>
                                            </div>
                                        </div>
                                    </div>
                                    <div id="collapseOne{{ 'accordionItem' . $key }}"
                                        class="accordion-collapse collapse show"
                                        aria-labelledby="headingOne{{ 'accordionItem' . $key }}"
                                        data-bs-parent="#accordionExample{{ 'accordionItem' . $key }}" style="">
                                        <div class="accordion-body">
                                            <div class="accordion-body__order">
                                                <ul class="accordion-body__list">
                                                    <li>
                                                        <span>@lang('Item Price')</span>
                                                        <span>{{ showAmount($item->item_price) }}</span>
                                                    </li>
                                                    <li><span>@lang('Quantity')</span>
                                                        <span>{{ $item->quantity }}</span>
                                                    </li>
                                                    @if ($item->variations)
                                                        <li><span class="title">Variants:</span></li>
                                                        @foreach ($item->variations ?? [] as $variation)
                                                            <li><span>{{ __($variation[0]) }}</span>
                                                                <span>{{ showAmount($variation[1]) }}</span>
                                                            </li>
                                                        @endforeach
                                                    @endif

                                                    @if ($item->addons)
                                                        <li><span class="title">Addons:</span></li>
                                                        @foreach ($item->addons ?? [] as $addon)
                                                            <li><span>{{ __($addon[0]) }}</span>
                                                                <span>{{ showAmount($addon[1]) }}</span>
                                                            </li>
                                                        @endforeach
                                                    @endif

                                                    @if ($item->additional_notes)
                                                        <li>
                                                            <span class="title">@lang('Additional Notes'):</span>
                                                        </li>
                                                        <li>
                                                            <span>{{ __($item->additional_notes) }}</span>
                                                        </li>
                                                    @endif

                                                </ul>
                                                <ul class="accordion-body__total">
                                                    <li class="title"><span>@lang('Subtotal')</span>
                                                        <span>{{ showAmount($item->total_price) }}</span>
                                                    </li>
                                                </ul>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        @endforeach

                        <div class="order-details-address">
                            <label for="">@lang('Order Address'):</label>
                            <p>{{ __($order->address) }}</p>
                        </div>

                        <div class="order-details-total">
                            <ul class="accordion-body__price">
                                <li><span>@lang('Status')
                                        @if ($order->status == Status::ORDER_DELIVERED)
                                            <span class="infoIcon" data-toggle="tooltip" data-placement="top"
                                                title="@lang('Payment will get dispersed once user confirms the order')">
                                                <i class="fas fa-info-circle"></i>
                                            </span>
                                        @endif
                                    </span><span>@php echo $order->statusBadge @endphp</span></li>

                                <li><span>@lang('Payment Type')</span><span>@php echo $order->typeBadge @endphp</span></li>
                                <li><span>@lang('Subtotal')</span><span>{{ showAmount($subTotal) }}</span>
                                </li>
                                <li><span>@lang('Vat')</span><span>{{ showAmount($order->vat) }}</span>
                                </li>
                                <li><span>@lang('Delivery Fee')</span><span>{{ showAmount($order->delivery_charge) }}</span>
                                </li>
                            </ul>
                            <ul class="accordion-body__total">
                                <li class="total">
                                    <span>@lang('Total')</span><span>{{ showAmount($order->total_price) }}</span>
                                </li>
                            </ul>
                        </div>

                        <div class="order_action__btn">
                            @if ($order->status == Status::ORDER_PROCESSING || $order->status == Status::ORDER_ON_DELIVERY)
                                <button class="btn w-100 btn-location btn--danger btn--md confirmationBtn"
                                    data-question="@lang('Are you sure to cancle this order') ?"
                                    data-action="{{ route('restaurant.order.cancel', $order->id) }}">@lang('Cancel Order')</button>
                            @endif
                            @if ($order->status == Status::ORDER_PROCESSING)
                                <button class="btn w-100 btn-location btn--base btn--md confirmationBtn"
                                    data-question="@lang('Is the order out for delivery')?"
                                    data-action="{{ route('restaurant.order.on.delivery.submit', $order->id) }}">@lang('Out for Delivery')</button>
                            @endif
                            @if ($order->status == Status::ORDER_ON_DELIVERY)
                                <button class="btn w-100 btn-location btn--base btn--md confirmationBtn"
                                    data-question="@lang('Is the order delivered')?"
                                    data-action="{{ route('restaurant.order.deliver', $order->id) }}">@lang('Order Delivered')</button>
                            @endif
                        </div>

                    </div>
                </div>
            </div>
        </div>
    </section>

    <x-confirmation-modal />
@endsection
