@extends($activeTemplate . 'restaurant.layouts.master')
@section('content')
    <div class="py-70">
        <div class="container">
            <div class="row justify-content-center mt-2">
                <div class="col-lg-12 ">
                    <div class="dashboard-table">
                        <div class="dashbaord-table-header">
                            <h6 class="card-header__title mb-0">{{ $pageTitle }} <i
                                    class="las la-hamburger text--base"></i></h6>
                            <form class="search-form active">
                                <input type="text" name="search" class="form--control" value="{{ request()->search }}"
                                    placeholder="@lang('Search here')...">
                                <button type="submit" class="search-form__btn"><i class="las la-search"></i></button>
                            </form>
                        </div>

                        <table class="table table--responsive--lg">
                            <thead>
                                <tr>
                                    <th>@lang('Image')</th>
                                    <th>@lang('Name')</th>
                                    <th>@lang('Description')</th>
                                    <th>@lang('Price')</th>
                                    <th>@lang('Status')</th>
                                    <th>@lang('Action')</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($foods as $food)
                                    <tr>
                                        <td>
                                            <div class="user-info__thumb">
                                                <img src="{{ getImage(getFilePath('food') . '/thumb_' . $food->image, getFileThumbSize('food')) }}"
                                                    class="fit-image" alt="img not found">
                                            </div>
                                        </td>
                                        <td>
                                            {{ __($food->name) }}
                                        </td>
                                        <td>
                                            {{ __(strLimit($food->short_description)) }}
                                        </td>
                                        <td>
                                            {{ showAmount($food->price) }}
                                        </td>
                                        <td>
                                            @php echo $food->statusBadge @endphp
                                        </td>
                                        <td>
                                            <div class="d-flex flex-wrap gap-2 justify-content-end">
                                                <a href="{{ route('restaurant.food.overview', $food->id) }}"
                                                    class="btn btn--sm btn--base btn-outline--base btn--sm">
                                                    <i class="la la-pen"></i>
                                                </a>

                                                @if ($food->status == Status::FOOD_DRAFT)
                                                    <button
                                                        class="btn btn--sm btn-outline--success ms-1 confirmationBtn btn--sm"
                                                        data-question="@lang('Are you sure to publish this food?')"
                                                        data-action="{{ route('restaurant.food.status', $food->id) }}">
                                                        <i class="la la-eye"></i> @lang('Publish')
                                                    </button>
                                                @else
                                                    <button
                                                        class="btn btn--sm btn-outline--danger ms-1 confirmationBtn btn--sm"
                                                        data-question="@lang('Are you sure to draft this food?')"
                                                        data-action="{{ route('restaurant.food.status', $food->id) }}">
                                                        <i class="la la-eye-slash"></i> @lang('Draft')
                                                    </button>
                                                @endif
                                            </div>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td class="text-muted empty-message" colspan="100%">{{ __($emptyMessage) }}</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                    <div class="mt-3">
                        @if ($foods->hasPages())
                            {{ paginateLinks($foods) }}
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </div>
    <x-confirmation-modal />
@endsection
