@extends($activeTemplate . 'restaurant.layouts.master')
@section('content')
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-9">
                @include($activeTemplate . 'restaurant.partials.food_progress_bar')
            </div>
        </div>
        <div class="card custom--card mt-5 mb-3">
            <div class="card-body">
                <form id="foodForm">
                    <div class="row justify-content-center">
                        <div class="col-lg-12">
                            <div class="category">
                                <div class="dragndrop old">
                                    <div class="form-group mb-0">
                                        <div class="input-images"></div>
                                    </div>
                                </div>
                            </div>

                        </div>
                    </div>
                </form>
            </div>
        </div>

        <div class="d-flex justify-content-between flex-wrap gap-3">
            <small class="mt-3 text-muted"> @lang('Supported Files'): <b>@lang('.png, .jpg, .jpeg').</b> @lang('Image will be resized into')
                <b>{{ getFileSize('food') }}</b> px </small>
            @if (!request()->routeIs('restaurant.food.publish'))
                <button class="btn btn--base" id="saveAndContinue" type="button">
                    @lang('Save & Continue') <i class="las la-angle-right"></i>
                </button>
            @endif
        </div>

    </div>
@endsection

@push('style-lib')
    <link rel="stylesheet" href="{{ asset('assets/restaurant/css/image-uploader.min.css') }}">
@endpush

@push('script-lib')
    <script src="{{ asset('assets/restaurant/js/image-uploader.min.js') }}"></script>
@endpush

@push('style')
    <style>
        .custom--card .card-body {
            padding: 10px 15px
        }

        .category .dragndrop .form-label-two {
            margin-bottom: 10px;
        }

        .image-uploader {
            border: none !important;
        }

        .image-uploader .uploaded {
            padding: 0 !important;
        }
    </style>
@endpush

@push('script')
    <script>
        (function($) {
            "use strict";

            $('.input-images').imageUploader({

                @if (isset($food->image))
                    preloaded: [{
                        id: '{{ $food->image }}',
                        src: '{{ getImage(getFilePath('food') . '/' . $food->image, getFileSize('food')) }}'
                    }],
                @endif

                imagesInputName: 'image',
                preloadedInputName: 'old',
                maxFiles: 1
            });

            //Ajax
            $('#saveAndContinue').on('click', function() {
                var btn = $(this);
                var btnName = `@lang('Save & Continue') <i class="las la-angle-right"></i>`;

                //store
                var formData = new FormData($('#foodForm')[0]);
                var url = '{{ route('restaurant.food.store.image', @$food->id ?? '') }}';
                var token = '{{ csrf_token() }}';
                formData.append('_token', token);


                $.ajax({
                    url: url,
                    method: 'POST',
                    data: formData,
                    processData: false,
                    contentType: false,
                    beforeSend: function() {
                        var btnAfterSubmit =
                            `<div class="spinner-border"></div> @lang('Saving')...`;
                        btn.html(btnAfterSubmit);
                        btn.attr('disabled', true);
                    },
                    complete: function(e) {
                        btn.html(btnName);
                        btn.removeAttr('disabled');
                    },
                    success: function(response) {
                        if (response.success) {
                            if (!response.is_update) {
                                window.location.href = response.redirect_url
                            } else {
                                notify('success', `@lang('Food image updated successfully')`);
                                btn.html(btnName);
                                btn.removeAttr('disabled');
                            }
                        } else {
                            notify('error', response.message);
                            btn.html(btnName);
                            btn.removeAttr('disabled');
                        }
                    },
                    error: function(xhr, status, error) {
                        notify('error', error);
                        btn.html(btnName);
                        btn.removeAttr('disabled');
                    }
                });
            });

        })(jQuery);
    </script>
@endpush
