@extends($activeTemplate . 'restaurant.layouts.master')

@section('content')
    <div class="py-70">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-md-12">
                    <div class="card custom--card">
                        <div class="card-body p-0">
                            <div class="dashboard-table">
                                <div class="dashbaord-table-header">
                                    <h6 class="card-header__title mb-0">
                                        {{ $pageTitle }} <i class="las la-file-invoice-dollar text--base"></i>
                                    </h6>
                                    <form class="search-form active">
                                        <input type="search" name="search" class="form--control"
                                            value="{{ request()->search }}" placeholder="@lang('Search by transactions')">
                                        <button type="submit" class="search-form__btn">
                                            <i class="las la-search"></i>
                                        </button>
                                    </form>
                                </div>
                                <table class="table custom--table table--responsive--xl">
                                    <thead>
                                        <tr>
                                            <th>@lang('Gateway | Transaction')</th>
                                            <th class="text-center">@lang('Initiated')</th>
                                            <th class="text-center">@lang('Amount')</th>
                                            <th class="text-center">@lang('Conversion')</th>
                                            <th class="text-center">@lang('Status')</th>
                                            <th>@lang('Details')</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @forelse($deposits as $deposit)
                                            <tr>
                                                <td>
                                                    <div>
                                                        <span class="fw-bold">
                                                            <span class="text--base">
                                                                @if ($deposit->method_code < 5000)
                                                                    {{ __(@$deposit->gateway->name) }}
                                                                @else
                                                                    @lang('Google Pay')
                                                                @endif
                                                            </span>
                                                        </span>
                                                        <br>
                                                        <small>{{ $deposit->trx }}</small>
                                                    </div>
                                                </td>
                                                <td class="text-center">
                                                    <div>
                                                        {{ showDateTime($deposit->created_at) }}<br>
                                                        {{ diffForHumans($deposit->created_at) }}
                                                    </div>
                                                </td>
                                                <td class="text-center">
                                                    <div>
                                                        {{ showAmount($deposit->amount) }} +
                                                        <span class="text--danger" data-bs-toggle="tooltip"
                                                            data-bs-placement="top" data-bs-title="@lang('Charge')">
                                                            {{ showAmount($deposit->charge) }}
                                                        </span>
                                                        <br>
                                                        <strong data-bs-toggle="tooltip" title="@lang('Amount with charge')">
                                                            {{ showAmount($deposit->amount + $deposit->charge) }}
                                                        </strong>
                                                    </div>
                                                </td>
                                                <td class="text-center">
                                                    <div>
                                                        1 {{ __(gs('cur_text')) }} =
                                                        {{ showAmount($deposit->rate, currencyFormat: false) }}
                                                        {{ __($deposit->method_currency) }}
                                                        <br>
                                                        <strong>
                                                            {{ showAmount($deposit->final_amount, currencyFormat: false) }}
                                                            {{ __($deposit->method_currency) }}
                                                        </strong>
                                                    </div>
                                                </td>
                                                <td class="text-center">
                                                    @php echo $deposit->statusBadge @endphp
                                                </td>
                                                @php
                                                    $details = [];
                                                    if (
                                                        $deposit->method_code >= 1000 &&
                                                        $deposit->method_code <= 5000
                                                    ) {
                                                        foreach (@$deposit->detail ?? [] as $key => $info) {
                                                            $details[] = $info;
                                                            if ($info->type == 'file') {
                                                                $details[$key]->value = route(
                                                                    'restaurant.download.attachment',
                                                                    encrypt(getFilePath('verify') . '/' . $info->value),
                                                                );
                                                            }
                                                        }
                                                    }
                                                @endphp
                                                <td>
                                                    @if ($deposit->method_code >= 1000 && $deposit->method_code <= 5000)
                                                        <a href="javascript:void(0)"
                                                            class="btn btn--sm btn--base btn-outline--base detailBtn"
                                                            data-info="{{ json_encode($details) }}"
                                                            @if ($deposit->status == Status::PAYMENT_REJECT) data-admin_feedback="{{ $deposit->admin_feedback }}" @endif>
                                                            <i class="las la-desktop"></i>
                                                        </a>
                                                    @else
                                                        <a href="javascript:void(0)"
                                                            class="btn btn--sm btn--base btn-outline--base autoBtn"
                                                            data-bs-toggle="tooltip" title="@lang('Automatically processed')">
                                                            <i class="las la-check"></i>
                                                        </a>
                                                    @endif

                                                </td>
                                            </tr>
                                        @empty
                                            <tr>
                                                <td colspan="100%" class="empty-message">{{ __($emptyMessage) }}</td>
                                            </tr>
                                        @endforelse
                                    </tbody>
                                </table>

                            </div>
                        </div>
                        @if ($deposits->hasPages())
                            <div class="card-footer">
                                {{ paginateLinks($deposits) }}
                            </div>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </div>

    {{-- APPROVE MODAL --}}
    <div id="detailModal" class="modal fade" tabindex="-1" role="dialog">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">@lang('Details')</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <ul class="list-group userData mb-2"></ul>
                    <div class="feedback"></div>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('style')
    <style>
        .autoBtn {
            opacity: 0.7;
        }
    </style>
@endpush

@push('script')
    <script>
        $(document).ready(function() {
            (function($) {
                "use strict";
                $('.detailBtn').on('click', function() {
                    var modal = $('#detailModal');

                    var userData = $(this).data('info');

                    var html = '';
                    if (userData) {
                        userData.forEach(element => {
                            if (element.type != 'file') {
                                html += `
                                <li class="list-group-item d-flex justify-content-between align-items-center">
                                    <span>${element.name}</span>
                                    <span>${element.value}</span>
                                </li>`;
                            } else {
                                html += `
                                <li class="list-group-item d-flex justify-content-between align-items-center">
                                    <span>${element.name}</span>
                                    <span><a href="${element.value}"><i class="fa-regular fa-file"></i> @lang('Attachment')</a></span>
                                </li>`;
                            }
                        });
                    }

                    modal.find('.userData').html(html);

                    var adminFeedback = $(this).data('admin_feedback') !== undefined ? `
                        <div class="my-3">
                            <strong>@lang('Admin Feedback')</strong>
                            <p>${$(this).data('admin_feedback')}</p>
                        </div>
                    ` : '';

                    modal.find('.feedback').html(adminFeedback);

                    modal.modal('show');
                });

                var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'));
                var tooltipList = tooltipTriggerList.map(function(tooltipTriggerEl) {
                    return new bootstrap.Tooltip(tooltipTriggerEl);
                });
            })(jQuery);
        });
    </script>
@endpush
