@extends($activeTemplate . 'restaurant.layouts.master')
@section('content')
    @php
        $kyc = getContent('kyc.content', true);
        $restaurant = authRestaurant();
    @endphp

    <div class="notice"></div>

    @if (authRestaurant()->kv == Status::KYC_UNVERIFIED && authRestaurant()->kyc_rejection_reason)
        <div class="dashboard-widget style-danger mb-4 d-flex align-items-center">
            <div class="dashboard-widget__icon flex-center me-3">
                <i class="las la-user-times"></i>
            </div>
            <div class="dashboard-widget__content">
                <h5 class="dashboard-widget__text">@lang('KYC Documents Rejected')</h5>
                <p class="dashboard-widget__number">{{ __(@$kyc->data_values->reject) }}
                    <a href="{{ route('restaurant.kyc.form') }}">@lang('Click Here to Re-submit Documents')</a>.
                </p>
                <p>
                    @lang('You can')
                    <a href="{{ route('restaurant.kyc.data') }}">@lang('view your KYC data')</a>
                    @lang('or')
                    <a href="javascript:void(0)" data-bs-toggle="modal"
                        data-bs-target="#kycRejectionReason">@lang('see the reason for rejection')</a>.
                </p>
            </div>
        </div>
    @elseif(authRestaurant()->kv == Status::KYC_UNVERIFIED)
        <div class="dashboard-widget style-info mb-4 d-flex align-items-center">
            <div class="dashboard-widget__icon flex-center me-3">
                <i class="las la-user-check"></i>
            </div>
            <div class="dashboard-widget__content">
                <h5 class="dashboard-widget__text">@lang('KYC Verification required')</h5>
                <p class="dashboard-widget__number">{{ __(@$kyc->data_values->required) }}
                    <a href="{{ route('restaurant.kyc.form') }}">@lang('Click Here to Submit Documents')</a>
                </p>
            </div>
        </div>
    @elseif(authRestaurant()->kv == Status::KYC_PENDING)
        <div class="dashboard-widget style-warning mb-4 d-flex align-items-center">
            <div class="dashboard-widget__icon flex-center me-3">
                <i class="las la-user-clock"></i>
            </div>
            <div class="dashboard-widget__content">
                <h5 class="dashboard-widget__text">@lang('KYC Verification pending')</h5>
                <p class="dashboard-widget__number">{{ __(@$kyc->data_values->pending) }}
                    <a href="{{ route('restaurant.kyc.data') }}">@lang('See KYC Data')</a>
                </p>
            </div>
        </div>
    @endif


    <div class="dashboard-widget-wrapper">
        <div class="row gy-4 justify-content-center">
            <div class="col-xxl-3 col-sm-6 col-xsm-6">
                <div class="dashboard-widget flex-align style-warning">
                    <a href="{{ route('restaurant.transactions') }}" class="link-to-go"></a>
                    <div class="dashboard-widget__icon flex-center">
                        <i class="las la-credit-card"></i>
                    </div>
                    <div class="dashboard-widget__content">
                        <span class="dashboard-widget__text">@lang('Balance')</span>
                        <h5 class="dashboard-widget__number">{{ showAmount($widget['balance']) }}
                        </h5>
                    </div>
                </div>
            </div>
            <div class="col-xxl-3 col-sm-6 col-xsm-6">
                <div class="dashboard-widget flex-align style-success">
                    <a href="{{ route('restaurant.order.index') }}" class="link-to-go"></a>
                    <div class="dashboard-widget__icon flex-center">
                        <i class="las la-shopping-cart "></i>
                    </div>
                    <div class="dashboard-widget__content">
                        <span class="dashboard-widget__text">@lang('Total Orders')</span>
                        <h5 class="dashboard-widget__number">{{ $widget['total_orders'] }}</h5>
                    </div>
                </div>
            </div>
            <div class="col-xxl-3 col-sm-6 col-xsm-6">
                <div class="dashboard-widget flex-align style-primary">
                    <a href="{{ route('restaurant.order.active') }}" class="link-to-go"></a>
                    <div class="dashboard-widget__icon flex-center">
                        <i class="las la-shopping-cart "></i>
                    </div>
                    <div class="dashboard-widget__content">
                        <span class="dashboard-widget__text">@lang('Active Orders')</span>
                        <h5 class="dashboard-widget__number">{{ $widget['active_orders'] }}</h5>
                    </div>
                </div>
            </div>

            <div class="col-xxl-3 col-sm-6 col-xsm-6">
                <div class="dashboard-widget flex-align style-danger">
                    <a href="{{ route('restaurant.order.cancelled') }}" class="link-to-go"></a>
                    <div class="dashboard-widget__icon flex-center">
                        <i class="las la-times-circle "></i>
                    </div>
                    <div class="dashboard-widget__content">
                        <span class="dashboard-widget__text">@lang('Cancelled Orders')</span>
                        <h5 class="dashboard-widget__number">{{ $widget['cancelled_orders'] }}</h5>
                    </div>
                </div>
            </div>

            <div class="col-xxl-3 col-sm-6 col-xsm-6">
                <div class="dashboard-widget flex-align style-warning">
                    <a href="{{ route('restaurant.order.on.delivery') }}" class="link-to-go"></a>
                    <div class="dashboard-widget__icon flex-center">
                        <i class="las la-truck "></i>
                    </div>
                    <div class="dashboard-widget__content">
                        <span class="dashboard-widget__text">@lang('On Delivery Orders')</span>
                        <h5 class="dashboard-widget__number">{{ $widget['onDelivery_orders'] }}</h5>
                    </div>
                </div>
            </div>
            
            <div class="col-xxl-3 col-sm-6 col-xsm-6">
                <div class="dashboard-widget flex-align style-primary">
                    <a href="{{ route('restaurant.order.processing') }}" class="link-to-go"></a>
                    <div class="dashboard-widget__icon flex-center">
                        <i class="las la-spinner "></i>
                    </div>
                    <div class="dashboard-widget__content">
                        <span class="dashboard-widget__text">@lang('Processing Orders')</span>
                        <h5 class="dashboard-widget__number">{{ $widget['processing_orders'] }}</h5>
                    </div>
                </div>
            </div>


            
        </div>
    </div>
    <!-- Dashboard Card End -->

    <div class="dashboard-widget-wrapper">
        <h6 class="dashboard-widget-wrapper__title mb-3">@lang('Sold Amount')</h6>
        <div class="row gy-4 justify-content-center">
            <div class="col-xxl-4 col-sm-6 col-xsm-6">
                <div class="dashboard-widget flex-align style-warning">
                    <div class="dashboard-widget__icon flex-center">
                        7
                    </div>
                    <div class="dashboard-widget__content">
                        <span class="dashboard-widget__text">@lang('Last 7 Days')</span>
                        <h5 class="dashboard-widget__number">
                            {{ showAmount($widget['sold_last_7_days']) }}</h5>
                    </div>
                </div>
            </div>
            <div class="col-xxl-4 col-sm-6 col-xsm-6">
                <div class="dashboard-widget flex-align style-success">
                    <div class="dashboard-widget__icon flex-center">
                        15
                    </div>
                    <div class="dashboard-widget__content">
                        <span class="dashboard-widget__text">@lang('Last 15 Days')</span>
                        <h5 class="dashboard-widget__number">
                            {{ showAmount($widget['sold_last_15_days']) }}</h5>
                    </div>
                </div>
            </div>
            <div class="col-xxl-4 col-sm-6 col-xsm-6">
                <div class="dashboard-widget flex-align style-primary">
                    <div class="dashboard-widget__icon flex-center">
                        30
                    </div>
                    <div class="dashboard-widget__content">
                        <span class="dashboard-widget__text">@lang('Last 30 Days')</span>
                        <h5 class="dashboard-widget__number">
                            {{ showAmount($widget['sold_last_30_days']) }}</h5>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="row gy-4 justify-content-center mb-3">
        <div class="col-sm-6">
            <div class="card custom--card">
                <div class="card-body">
                    <h6 class="card-title">@lang('Sales Report') (@lang('Last 30 Days'))</h5>
                        <div id="apex-line"></div>
                </div>
            </div>
        </div>
        <div class="col-sm-6">
            <div class="card custom--card">
                <div class="card-body">
                    <h6 class="card-title">@lang('Monthly Deposit & Withdraw Report') (@lang('Last 12 Month'))</h5>
                        <div id="apex-bar-chart"> </div>
                </div>
            </div>
        </div>
    </div>

    <h6 class="mt-3 mb-0">@lang('Latest Orders')</h6>
    <div class="row gy-4 justify-content-center mt-1">
        <div class="col-12">
            <div class="dashboard-table">
                <table class="table table--responsive--lg">
                    <thead>
                        <tr>
                            <th>@lang('User')</th>
                            <th>@lang('Address')</th>
                            <th>@lang('Total Price')</th>
                            <th>@lang('Payment Type')</th>
                            <th>@lang('Status')</th>
                            <th>@lang('Action')</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($latestOrders as $order)
                            <tr>
                                <td>
                                    <div>
                                        {{ __($order->user->fullname) }} <br />
                                        <small><a
                                                href="{{ route('restaurant.order.index', ['search' => $order->user->username]) }}">{{ __($order->user->username) }}</a></small>
                                    </div>
                                </td>
                                <td>
                                    {{ __(strLimit($order->address, 40)) }}
                                </td>

                                <td>
                                    <div>
                                        {{ showAmount($order->total_price) }} <br>
                                        <small
                                            class="text--base">{{ showDateTime($order->created_at, 'd/m/y @ h A') }}</small>
                                    </div>
                                </td>

                                <td>
                                    @php echo $order->typeBadge @endphp
                                </td>

                                <td>
                                    @php echo $order->statusBadge @endphp
                                    @if ($order->status == Status::ORDER_DELIVERED)
                                        <span class="infoIcon" data-toggle="tooltip" data-placement="top"
                                            title="@lang('Payment will get dispersed once user confirms the order')">
                                            <i class="fas fa-info-circle"></i>
                                        </span>
                                    @endif
                                </td>

                                <td>
                                    <a href="{{ route('restaurant.order.details', $order->id) }}"
                                        class="btn btn--sm btn--success btn-outline--success btn--sm">
                                        <i class="la la-eye"></i>
                                    </a>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td class="text-muted empty-message" colspan="100%">{{ __($emptyMessage) }}</td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    @if (authRestaurant()->kv == Status::KYC_UNVERIFIED && authRestaurant()->kyc_rejection_reason)
        <div class="modal fade" id="kycRejectionReason">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">@lang('KYC Document Rejection Reason')</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <p>{{ authRestaurant()->kyc_rejection_reason }}</p>
                    </div>
                </div>
            </div>
        </div>
    @endif
@endsection


@push('script')
    <script src="{{ asset('assets/admin/js/vendor/apexcharts.min.js') }}"></script>
    <script src="{{ asset('assets/admin/js/vendor/chart.js.2.8.0.js') }}"></script>

    <script>
        (function($) {
            "use strict";

            // apex-bar chart
            var options = {
                series: [{
                    name: 'Total Deposit',
                    data: [
                        @foreach ($months as $month)
                            {{ getAmount(@$depositsMonth->where('months', $month)->first()->depositAmount) }},
                        @endforeach
                    ]
                }, {
                    name: 'Total Withdraw',
                    data: [
                        @foreach ($months as $month)
                            {{ getAmount(@$withdrawalMonth->where('months', $month)->first()->withdrawAmount) }},
                        @endforeach
                    ]
                }],
                chart: {
                    type: 'bar',
                    height: 450,
                    toolbar: {
                        show: false
                    }
                },
                plotOptions: {
                    bar: {
                        horizontal: false,
                        columnWidth: '50%',
                        endingShape: 'rounded'
                    },
                },
                dataLabels: {
                    enabled: false
                },
                stroke: {
                    show: true,
                    width: 2,
                    colors: ['transparent']
                },
                xaxis: {
                    categories: @json($months),
                },
                yaxis: {
                    title: {
                        text: "{{ __(gs('cur_sym')) }}",
                        style: {
                            color: '#7c97bb'
                        }
                    }
                },
                grid: {
                    xaxis: {
                        lines: {
                            show: false
                        }
                    },
                    yaxis: {
                        lines: {
                            show: false
                        }
                    },
                },
                fill: {
                    opacity: 1
                },
                tooltip: {
                    y: {
                        formatter: function(val) {
                            return "{{ __(gs('cur_sym')) }}" + val + " "
                        }
                    }
                }
            };
            var chart = new ApexCharts(document.querySelector("#apex-bar-chart"), options);
            chart.render();

            // apex-line chart
            var options = {
                chart: {
                    height: 450,
                    type: "area",
                    toolbar: {
                        show: false
                    },
                    dropShadow: {
                        enabled: true,
                        enabledSeries: [0],
                        top: -2,
                        left: 0,
                        blur: 10,
                        opacity: 0.08
                    },
                    animations: {
                        enabled: true,
                        easing: 'linear',
                        dynamicAnimation: {
                            speed: 1000
                        }
                    },
                },
                dataLabels: {
                    enabled: false
                },
                series: [{
                    name: "Monthly Sales",
                    data: [
                        @foreach ($salesReport['date'] as $salesDate)
                            {{ @$sales->where('date', $salesDate)->first()->total_price ?? 0 }},
                        @endforeach
                    ]
                }],
                fill: {
                    type: "gradient",
                    gradient: {
                        shadeIntensity: 1,
                        opacityFrom: 0.7,
                        opacityTo: 0.9,
                        stops: [0, 90, 100]
                    }
                },
                xaxis: {
                    categories: [
                        @foreach ($salesReport['date'] as $salesDate)
                            "{{ $salesDate }}",
                        @endforeach
                    ]
                },
                grid: {
                    padding: {
                        left: 5,
                        right: 5
                    },
                    xaxis: {
                        lines: {
                            show: false
                        }
                    },
                    yaxis: {
                        lines: {
                            show: false
                        }
                    },
                },
            };

            var chart = new ApexCharts(document.querySelector("#apex-line"), options);

            chart.render();

        })(jQuery);
    </script>
@endpush
