@extends($activeTemplate . 'layouts.frontend')

@section('content')
    @if (gs('restaurant_registration'))
        @php
            $policyPages = getContent('policy_pages.element', false, null, true);
            $loginRegistration = getContent('login_registration.content', true);
        @endphp
        <div class="inner-banner-breadcrumbs">
            <div class="container">
                <div class="row justify-content-center">
                    <ul class="breadcrumbs d-flex flex-wrap align-items-center justify-content-center">
                        <li><a href="{{ route('home') }}">@lang('Home')</a></li>
                        <li>{{ $pageTitle }}</li>
                    </ul>
                </div>
            </div>
        </div>
        <section class="account section-bg-two pt-80 pb-80">
            <img class="account-shape-three"
                src="{{ frontendImage('login_registration', @$loginRegistration->data_values->image_one, '515x380') }}"
                alt="img not found" />
            <img class="account-shape-four"
                src="{{ frontendImage('login_registration', @$loginRegistration->data_values->image_two, '630x405') }}"
                alt="img not found" />
            <img class="account-shape-four-dark"
                src="{{ frontendImage('login_registration', @$loginRegistration->data_values->image_two_dark, '630x405') }}"
                alt="img not found" />
            <div class="container">
                <div class="row justify-content-center">
                    <div class="col-lg-6 col-md-10">
                        <div class="change-password">
                            <form action="{{ route('restaurant.register') }}" method="POST"
                                class="signup-form verify-gcaptcha disableSubmission">
                                @csrf
                                <div class="signup-form-top text-center pb-30">
                                    <div class="signup-page__content text-center">
                                        <h2>@lang('Register')</h2>
                                    </div>
                                </div>
                                @include($activeTemplate . 'partials.social_login')
                                <div class="row">

                                    <div class="col-12">
                                        <div class="form-group">
                                            <div class="input-group">
                                                <input type="text" id="email" placeholder="none"
                                                    class="form-control form--control checkUser" name="email"
                                                    value="{{ old('email') }}" required>
                                                <label for="email">@lang('E-Mail Address')</label>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-12">
                                        <div class="form-group">
                                            <div class="input-group">
                                                <select id="location" name="location" placeholder="none"
                                                    class="form-select form-control form--control select2-basic" required>
                                                    @foreach ($locations as $location)
                                                        <option value="{{ $location->id }}" name="location">
                                                            {{ __($location->name) }}</option>
                                                    @endforeach
                                                </select>
                                                <label for="location">@lang('Location')</label>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-12">
                                        <div class="form-group">
                                            <div class="input-group">
                                                <input type="number" id="mobile" placeholder="none"
                                                    class="form-control form--control checkUser" name="mobile"
                                                    value="{{ old('mobile') }}" required>
                                                <label for="mobile">@lang('Mobile')</label>
                                            </div>
                                            <small class="text--danger mobileExist"></small>
                                        </div>
                                    </div>

                                    <div class="col-12">
                                        <div class="form-group">
                                            <div class="input-group">
                                                <input type="password" id="password" placeholder="none"
                                                    class="form-control form--control @if (gs('secure_password')) secure-password @endif"
                                                    name="password" required>
                                                <label for="password">@lang('Password')</label>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-12">
                                        <div class="form-group">
                                            <div class="input-group">
                                                <input name="password_confirmation" type="password" id="c-password"
                                                    placeholder="none" class="form-control form--control" required>
                                                <label for="c-password">@lang('Confirm Password')</label>
                                            </div>
                                        </div>
                                    </div>

                                    <x-captcha />

                                    @if (gs('agree'))
                                        <div class="col-12">
                                            <div class="form-group">
                                                <div class="form-check custom--checkbox">
                                                    <input class="form-check-input" type="checkbox" id="agree"
                                                        name="agree">
                                                    <label class="form-check-label" for="agree">
                                                        @lang('I agree with')
                                                    </label>
                                                    @foreach ($policyPages as $policy)
                                                        <a class="text--base"
                                                            href="{{ route('policy.pages', [slug(@$policy->data_values->title), $policy->id]) }}"
                                                            target="_blank">{{ __(@$policy->data_values->title) }}</a>
                                                        @if (!$loop->last)
                                                            ,
                                                        @endif
                                                    @endforeach
                                                </div>
                                            </div>
                                        </div>
                                    @endif

                                    <div class="col-12 mb-20 mt-3">
                                        <button type="submit" id="recaptcha" class="btn btn--base w-100 btn--md">
                                            @lang('Register')
                                        </button>
                                    </div>

                                    <div class="col-12">
                                        <p class="text-center heading-color mb-0">
                                            @lang('Already have an account?')
                                            <a href="{{ route('restaurant.login') }}"
                                                class="text--base">@lang('Login')</a>
                                        </p>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </section>

        <div class="modal fade" id="existModalCenter" tabindex="-1" role="dialog" aria-labelledby="existModalCenterTitle"
            aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="existModalLongTitle">@lang('You are with us')</h5>
                        <span type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                            <i class="las la-times"></i>
                        </span>
                    </div>
                    <div class="modal-body">
                        <p class="text-center">@lang('You already have an account please Login ')</p>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-dark btn--sm"
                            data-bs-dismiss="modal">@lang('Close')</button>
                        <a href="{{ route('restaurant.login') }}" class="btn btn--base btn--sm">@lang('Login')</a>
                    </div>
                </div>
            </div>
        </div>
    @else
        @include($activeTemplate . 'partials.registration_disabled')
    @endif
@endsection

@push('style')
    <style>
        .country-code .input-group-text {
            background: #fff !important;
        }

        .country-code select {
            border: none;
        }

        .country-code select:focus {
            border: none;
            outline: none;
        }
    </style>
@endpush

@if (gs('secure_password'))
    @push('script-lib')
        <script src="{{ asset('assets/global/js/secure_password.js') }}"></script>
    @endpush
@endif
