@php
    $text = isset($register) ? 'Register' : 'Login';
    $currentRouteName = Route::currentRouteName();
    $guard = explode('.', $currentRouteName)[0];
    $routeName = $guard . '.social.login';
@endphp
<div class="account-social">
    @if (@gs('socialite_credentials')->google->status == Status::ENABLE)
        <div class="continue-google">
            <a href="{{ route($routeName, 'google') }}" class="social-login-btn">
                <span class="google-icon">
                    <img src="{{ asset($activeTemplateTrue . 'images/google.svg') }}" alt="Google">
                </span>
            </a>
        </div>
    @endif
    @if (@gs('socialite_credentials')->facebook->status == Status::ENABLE)
        <div class="continue-facebook">
            <a href="{{ route($routeName, 'facebook') }}" class="social-login-btn">
                <span class="facebook-icon">
                    <img src="{{ asset($activeTemplateTrue . 'images/facebook.svg') }}" alt="Facebook">
                </span>
            </a>
        </div>
    @endif
    @if (@gs('socialite_credentials')->linkedin->status == Status::ENABLE)
        <div class="continue-facebook">
            <a href="{{ route($routeName, 'linkedin') }}" class="social-login-btn">
                <span class="facebook-icon">
                    <img src="{{ asset($activeTemplateTrue . 'images/linkdin.svg') }}" alt="Linkedin">
                </span>
            </a>
        </div>
    @endif
</div>

@if (
    @gs('socialite_credentials')->linkedin->status ||
        @gs('socialite_credentials')->facebook->status == Status::ENABLE ||
        @gs('socialite_credentials')->google->status == Status::ENABLE)
    <div class="text-center auth-devide">
        <span>@lang('OR')</span>
    </div>
@endif
