@if (gs('multi_language'))
    @php
        $language = App\Models\Language::all();
    @endphp
    <div class="dropdown-lang dropdown">
        @if (session('lang'))
            @php $selectedLanguage = $language->where('code', session('lang'))->first()  @endphp
            <a href="javascript:void(0)" class="language-btn dropdown-toggle" id="dropdownMenua1" data-bs-toggle="dropdown"
                aria-expanded="false">
                <img class="flag"
                    src="{{ getImage(getFilePath('language') . '/' . @$selectedLanguage->image, getFileSize('language')) }}"
                    alt="{{ $selectedLanguage->code }}">
                <span class="language-text">{{ __(@$selectedLanguage->name) }}</span>
            </a>
        @else
            @php $default = $language->where('is_default', Status::YES)->first() @endphp
            <a href="javascript:void(0)" class="language-btn dropdown-toggle" id="dropdownMenua1"
                data-bs-toggle="dropdown" aria-expanded="false">
                <img class="flag"
                    src="{{ getImage(getFilePath('language') . '/' . @$default->image, getFileSize('language')) }}"
                    alt="{{ $default->code }}">
                <span class="language-text">{{ __(@$default->name) }}</span>
            </a>
        @endif

        <ul class="dropdown-menu" aria-labelledby="dropdownMenuButton1">
            @foreach ($language as $item)
                <li><a href="{{ route('home') }}/change/{{ $item->code }}"><img class="flag"
                            src="{{ getImage(getFilePath('language') . '/' . $item->image, getFileSize('language')) }}"
                            alt="{{ $item->code }}"> {{ __($item->name) }}</a></li>
            @endforeach
        </ul>
    </div>
@endif
