@php
    $subscribe = getContent('subscribe.content', true);
    $contact_us = getContent('contact_us.content', true);
    $locations = App\Models\Location::active()->limit(8)->get();
    $categories = App\Models\Category::active()
        ->where('restaurant_id', Status::ADMIN_CATEGORIES)
        ->orderBy('sort_order')
        ->limit(8)
        ->get();
    $locationCount = $locations->count();
    $locationCurrentIndex = 0;

    $categoryCount = $categories->count();
    $categoryCurrentIndex = 0;

    $pages = App\Models\Page::where('tempname', $activeTemplate)
        ->where('is_default', Status::NO)
        ->get();
    $links = getContent('policy_pages.element');
    $authenticatedUser = authenticatedUser();
@endphp
<footer class="footer-area">
    <div class="footer-area-top pt-80 pb-80">
        <img src="{{ getImage($activeTemplateTrue . 'images/frame.png') }}" alt="img not found"
            class="footer-area-shape-one">
        <img src="{{ getImage($activeTemplateTrue . 'images/frame2.png') }}" alt="img not found"
            class="footer-area-shape-two">
        <div class="container">
            <div class="row gy-4">
                <div class="col-xl-3 col-lg-6 col-md-6 col-sm-6">
                    <div class="footer-widget">
                        <h4 class="footer-widget__title">
                            @lang('Categories')
                        </h4>
                        @while ($categoryCurrentIndex < $categoryCount)
                            <ul class="footer-widget__link style-one">
                                @for ($i = $categoryCurrentIndex; $i < min($categoryCurrentIndex + 4, $categoryCount); $i++)
                                    <li><a
                                            href="{{ route('category.foods', $categories[$i]->slug) }}">{{ ucfirst(__($categories[$i]->name)) }}</a>
                                    </li>
                                @endfor
                            </ul>
                            @php $categoryCurrentIndex += 4; @endphp
                        @endwhile
                    </div>
                </div>
                <div class="col-xl-3 col-lg-6 col-md-6 col-sm-6">
                    <div class="footer-widget footer-left-40">
                        <h4 class="footer-widget__title">
                            @lang('Coverage Area')
                        </h4>
                        @while ($locationCurrentIndex < $locationCount)
                            <ul class="footer-widget__link style-one">
                                @for ($i = $locationCurrentIndex; $i < min($locationCurrentIndex + 4, $locationCount); $i++)
                                    <li><a href="javascript:void(0)">{{ ucfirst(__($locations[$i]->name)) }}</a>
                                    </li>
                                @endfor
                            </ul>
                            @php $locationCurrentIndex += 4; @endphp
                        @endwhile
                    </div>
                </div>
                <div class="col-xl-3 col-lg-6 col-md-6 col-sm-6">
                    <div class="footer-widget footer-left-40">
                        <h4 class="footer-widget__title">
                            @lang('Help')
                        </h4>
                        <ul class="footer-widget__link style-two">
                            @php
                                $userLoggedIn = auth()->user();
                                $restaurantLoggedIn = auth()->guard('restaurant')->user();
                                $authenticated = $userLoggedIn || $restaurantLoggedIn;
                            @endphp
                            @if (!$authenticated)
                                <li>
                                    <a href="{{ route('user.login') }}">@lang('Login as User') </a>
                                </li>
                                <li>
                                    <a href="{{ route('restaurant.login') }}">@lang('Login as Restaurant') </a>
                                </li>
                            @else
                                @if ($userLoggedIn)
                                    <li>
                                        <a href="{{ route('restaurant.login') }}">@lang('Login as Restaurant') </a>
                                    </li>
                                @endif
                                @if ($restaurantLoggedIn)
                                    <li>
                                        <a href="{{ route('user.login') }}">@lang('Login as User') </a>
                                    </li>
                                @endif
                            @endif
                            @foreach ($pages as $k => $data)
                                <li>
                                    <a href="{{ route('pages', [$data->slug]) }}"> {{ __($data->name) }} </a>
                                </li>
                            @endforeach
                            @foreach ($links as $link)
                                <li><a
                                        href="{{ route('policy.pages', [slug(@$link->data_values->title), $link->id]) }}">{{ __(@$link->data_values->title) }}</a>
                                </li>
                            @endforeach
                        </ul>
                    </div>
                </div>
                <div class="col-xl-3 col-lg-6 col-md-6 col-sm-6">
                    <div class="footer-widget">
                        <h4 class="footer-widget__title">
                            {{ __(@$subscribe->data_values->heading) }}
                        </h4>
                        <p class="footer-widget__subtitle">{{ __(@$subscribe->data_values->description) }} </p>
                        <div class="footer-widget__newsletter">
                            <form action="main.php" class="subscribe-form" id="subscribe-form">
                                <input type="email" name="email" class="form-control form--control"
                                    placeholder="@lang('Your email')...">
                                <button type="submit" class="btn subscribe-btn"><i
                                        class="las la-long-arrow-alt-right"></i></button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>

        </div>
    </div>

    <div class="footer-bottom">
        <div class="container">
            <div class="row align-items-center text-center">
                <div class="col-12">
                    <div class="footer-bottom__left">
                        <p>{{ __(@$contact_us->data_values->website_footer) }}</p>
                        @php
                            $socialLinks = getContent('social_links.element');
                        @endphp
                        <ul class="social-list__footer">
                            @foreach ($socialLinks as $socialLink)
                                <li class="social-list__item__footer">
                                    <a href="{{ @$socialLink->data_values->url }}"
                                        class="social-list__footer__link flex-center" target="_blank">
                                        @php echo @$socialLink->data_values->social_icon @endphp
                                    </a>
                                </li>
                            @endforeach
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
</footer>


@push('script')
    <script>
        (function($) {
            "use strict";

            $('#subscribe-form').on('submit', function(e) {
                e.preventDefault();
                let formData = new FormData($(this)[0]);
                let $this = $(this);
                $.ajax({
                    headers: {
                        'X-CSRF-TOKEN': "{{ csrf_token() }}"
                    },
                    url: "{{ route('subscribe') }}",
                    method: "POST",
                    data: formData,
                    cache: false,
                    contentType: false,
                    processData: false,
                    beforeSend: function() {
                        $this.find('button[type=submit]').html(`
                        <span class="right-sidebar__button-icon">
                            <i class="las la-spinner la-spin"></i>
                        </span>`).attr('disabled', true);
                    },
                    complete: function(e) {
                        $this.find('button[type=submit]').html(
                            `<i class="las la-long-arrow-alt-right"></i>`
                        ).attr('disabled', false);
                    },
                    success: function(resp) {
                        if (resp.success) {
                            notify('success', resp.message);
                            $this.find('input[name=email]').val('')
                        } else {
                            notify('error', resp.message || resp.error);
                        }
                    }
                });
            });

        })(jQuery);
    </script>
@endpush
