@if (@$cartItems && count($cartItems))
    @php
        $orderTotalPrice = 0;
        $restaurant = $cartItems->first()->restaurant;
        $vat = $restaurant->vat;
        $deliveryFee = $restaurant->delivery_charge;
    @endphp

    <div class="cross-btn d-block">
        <i class="fas fa-times"></i>
    </div>

    <div class="your-cart__form">
        <h4 class="your-cart__title">@lang('Your cart')</h4>
        <p>@lang('Your Order Form') <a class="text--base fw-bold"
                href="{{ route('restaurant.details', $restaurant->slug) }}">{{ __($restaurant->restaurant_name) }}</a>
        </p>
    </div>
    <div class="your-cart__item your-cart__scroll">

        @foreach ($cartItems ?? [] as $item)
            @php
                $itemPrice = 0;
                $itemPrice = $itemPrice + $item->food->price;
                $details = '';
                foreach ($item->variations ?? [] as $variationItemId) {
                    $variationItem = App\Models\VariantItem::find($variationItemId);
                    $details .= $variationItem->name . ', ';
                    $itemPrice = $itemPrice + $variationItem->price;
                }
                foreach ($item->addons ?? [] as $addonsId) {
                    $addonItem = App\Models\Addon::find($addonsId);
                    $details .= $addonItem->name . ', ';
                    $itemPrice = $itemPrice + $addonItem->price;
                }
                $itemPrice = $itemPrice * $item->quantity;
                $orderTotalPrice = $orderTotalPrice + $itemPrice;
            @endphp

            <div class="your-cart__item-single d-flex justify-content-between">
                <div class="your-cart__box d-flex">
                    <div class="your-cart__item-single-thumb">
                        <img src="{{ getImage(getFilePath('food') . '/thumb_' . $item->food->image, getFileThumbSize('food')) }}"
                            alt="img not found">
                    </div>
                    <div class="your-cart__item-single-content">
                        <h4>{{ __($item->food->name) }}</h4>
                        <span>
                            {{ __(rtrim($details, ', ')) }}
                        </span>
                    </div>
                </div>
                <div class="your-cart__cunt">
                    <ul class="qnty-cart-list">
                        <li class="qnty-cart-list__item">
                            <div class="product-qty">
                                <button type="button" class="product-qty__btn product-qty__decrement cart-quantity-btn"
                                    data-id="{{ $item->id }}" data-type="-"><i class="fas fa-minus"></i></button>
                                <input type="number" class="product-qty__value product-qty__btn cart-quantity"
                                    value="{{ $item->quantity }}" data-id="{{ $item->id }}">
                                <button type="button" class="product-qty__btn product-qty__increment cart-quantity-btn"
                                    data-id="{{ $item->id }}" data-type="+"><i class="las la-plus"></i></button>
                            </div>
                        </li>
                    </ul>
                    <span>{{ showAmount($itemPrice) }}</span>
                </div>
            </div>
        @endforeach

        <div class="your-cart__item-total">
            <ul class="your-cart__amount pb-20">
                <li><span>@lang('Subtotal')</span><span>{{ showAmount($orderTotalPrice) }}</span>
                </li>
                <li><span>@lang('Delivery Fee')</span><span>{{ showAmount($deliveryFee) }}</span></li>
                <li><span>@lang('Vat')</span><span>{{ showAmount($orderTotalPrice * ($vat / 100)) }}</span>
                </li>
                <li><span>@lang('Total')(@lang('Incl').@lang('VAT'))</span><span>{{ showAmount($orderTotalPrice + $deliveryFee + $orderTotalPrice * ($vat / 100)) }}</span>
                </li>
            </ul>
            <div class="your-cart__item-right-btn">
                @auth
                    <a class="btn w-100 btn-location btn--base btn--md"
                        href="{{ route('user.order.checkout') }}">@lang('Go to Chckout')</a>
                @else
                    <button id="checkoutButton" class="btn w-100 btn-location btn--base btn--md">
                        @lang('Go to Checkout')
                    </button>
                @endauth
            </div>
        </div>
    </div>
@else
    {{-- empty cart  --}}
    <div class="cross-btn d-block">
        <i class="fas fa-times"></i>
    </div>
    <div class="your-cart__form">
        <h4 class="your-cart__title">@lang('Your cart')</h4>
        <div class="your-cart__form-icon">
            <img src="{{ getImage($activeTemplateTrue . 'images/cart.png') }}" alt="img not found">
        </div>
    </div>
    <div class="your-cart__item-total your-cart__item-border">
        <ul class="your-cart__amount pb-20">
            <li><span>@lang('Subtotal')</span><span>{{ showAmount(0.0) }}</span></li>
            <li><span>@lang('Total')(@lang('Incl').@lang('VAT'))</span><span>{{ showAmount(0.0) }}</span>
            </li>
        </ul>
        <div class="your-cart__item-right-btn">
            <button class="btn w-100 btn-disable btn--base btn--md">@lang('Go to Checkout')</button>
        </div>
    </div>
@endif


@push('script')
    <script>
        (function($) {
            "use strict";

            $(document).on("click", "#checkoutButton", function() {
                $('#cartLoginModal').modal('show');
                $(".your-cart").removeClass("active");
                $(".sidebar-overlay").removeClass("show");
            });

        })(jQuery);
    </script>
@endpush
