@extends($activeTemplate . 'layouts.app')
@section('panel')
    <div class="welcome-header pt-60 pb-60">
        <div class="container custom-container">
            <div class="row">
                <div class="col-6">
                    <div class="logo">
                        <a href="{{ route('home') }}" class="logo-w"><img src="{{ siteLogo('dark') }}" alt="logo-img" /></a>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <section class="welcome-banner pb-80"
        style="background: url('{{ getImage(getFilePath('maintenance') . '/' . @$maintenance->data_values->image, getFileSize('maintenance')) }}')">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-xl-10">
                    <div class="welcome-banner-wrapper text-center">
                        <div class="welcome-banner-inner">
                            <p class="welcome-banner__subtitle">
                                @php echo @$maintenance->data_values->description @endphp
                            </p>
                        </div>
                        <div class="welcome-banner__social">
                            <h4 class="title">@lang('Follow Us')</h4>
                            <div class="welcome-banner__social-media">
                                @php
                                    $socialLinks = getContent('social_links.element');
                                @endphp
                                <ul>
                                    @foreach ($socialLinks as $socialLink)
                                        <li>
                                            <a href="{{ @$socialLink->data_values->url }}" target="_blank">
                                                @php echo @$socialLink->data_values->social_icon @endphp
                                            </a>
                                        </li>
                                    @endforeach
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection
