@extends($activeTemplate . 'layouts.frontend')
@section('content')
    @php
        $banner = getContent('banner.content', true);
    @endphp
    
   

    <section class="banner-area section-bg-one pt-100 pb-100">
        <img src="{{ frontendImage('banner', @$banner->data_values->food_image_eight, '200x275') }}" alt="img not found"
            class="banner-shap-one">
        <img src="{{ getImage($activeTemplateTrue . 'images/building.png') }}" alt="img not found" class="banner-shap-two">
        <img src="{{ getImage($activeTemplateTrue . 'images/building-dark.png') }}" alt="img not found"
            class="banner-shap-two-dark">
        <div class="food-group">
            <img src="{{ frontendImage('banner', @$banner->data_values->food_image_five, '55x55') }}" alt="img not found"
                class="food-group-one">
            <img src="{{ frontendImage('banner', @$banner->data_values->food_image_six, '55x55') }}" alt="img not found"
                class="food-group-one">
            <img src="{{ frontendImage('banner', @$banner->data_values->food_image_seven, '55x55') }}" alt="img not found"
                class="food-group-one">
        </div>
        <div class="container">
            <div class="row align-items-center gy-4">
                <div class="col-xl-8 col-lg-7">
                    <div class="banner-area__content">
                        <h2 class="banner-area__content-title">{{ __(@$banner->data_values->heading) }}</h2>
                        <p class="banner-area__content-subtitle">{{ __(@$banner->data_values->description) }}</p>
                    </div>
                    <form action="{{ route('search') }}" class="banner-area__search-form d-flex align-items-center">
                        <div class="input-group location-has-icon">
                            <input type="text" name="search" placeholder="@lang('Enter Your Favourite restaurant')"
                                class="form-control form--control">
                            <label for="address">@lang('Enter Your Favourite restaurant')</label>
                        </div>
                        <div class="banner-search-btn">
                            <button class="btn btn--base" type="submit">@lang('Search')</button>
                        </div>
                    </form>
                </div>
                <div class="col-xl-4 col-lg-5 d-none d-lg-block">
                    <div class="banner-area__thumb">
                        <img src="{{ frontendImage('banner', @$banner->data_values->food_image_two, '80x70') }}"
                            alt="img not found" class="food-group-one food-one-box">
                        <img src="{{ frontendImage('banner', @$banner->data_values->food_image_three, '70x60') }}"
                            alt="img not found" class="food-group-one food-two-box">
                        <img src="{{ frontendImage('banner', @$banner->data_values->food_image_four, '60x60') }}"
                            alt="img not found" class="food-group-one food-three-box">
                        <img src="{{ frontendImage('banner', @$banner->data_values->food_image_one, '70x60') }}"
                            alt="img not found" class="food-group-one food-four-box">
                        <img class="w-100"
                            src="{{ frontendImage('banner', @$banner->data_values->banner_image, '600x515') }}"
                            alt="img not found">
                    </div>
                </div>
            </div>
        </div>
    </section>

    @if (@$sections->secs != null)
        @foreach (json_decode($sections->secs) as $sec)
            @include($activeTemplate . 'sections.' . $sec)
        @endforeach
    @endif
@endsection
