@extends($activeTemplate . 'layouts.frontend')
@section('content')
    <section class="common-body section-bg-two pt-80 pb-80">
        <div class="container">
            <div class="nearby-restaurant">
                <div class="row gy-4">
                    @foreach ($foods as $food)
                        <div class="col-xl-4 col-lg-6 col-md-6 col-sm-6 col--xm-6">
                            <x-food :food="$food" :isSection="true" />
                        </div>
                    @endforeach
                </div>
            </div>

            @if ($foods->isEmpty())
                <div class="card custom--card">
                    <div class="card-body">
                        <div class="empty__message">
                            <div class="thumb">
                                <img src="{{ getImage('assets/images/empty_list.png') }}" alt="img">
                            </div>
                            <h6 class="text-center ">{{ __($emptyMessage) }}</h6>
                        </div>
                    </div>
                </div>
            @endif


            <div class="pagination-area mt-4">
                {{ paginateLinks($foods) }}
            </div>
        </div>
    </section>
@endsection
