<div class="restaurant">
    <div class="restaurant__thumb">
        <a href="{{ route('restaurant.details', $restaurant->slug) }}"><img
                src="{{ getImage(getFilePath('restaurantCoverThumb') . '/' . $restaurant->cover_image_thumb, getFileSize('restaurantCoverThumb'), coverThumb: true) }}"
                alt="img not found"></a>
        <button class="restaurant__thumb-icon {{ restaurantIsFavorite($restaurant) }}"
            data-url={{ route('restaurant.favorite', $restaurant->id) }}>
            <i class="far fa-heart"></i>
        </button>
    </div>
    <div class="restaurant__info d-flex">
        <div class="restaurant__info-thumb">
            <a href="{{ route('restaurant.details', $restaurant->slug) }}"> <img
                    src="{{ getImage(getFilePath('restaurantProfile') . '/thumb_' . $restaurant->profile_image, getFileThumbSize('restaurantProfile'), $avatar = true) }}"
                    alt="img not found"></a>
        </div>
        <div class="restaurant__info-content">
            <h4 class="restaurant__info-content-title">
                <a
                    href="{{ route('restaurant.details', $restaurant->slug) }}">{{ __($restaurant->restaurant_name) }}</a>
            </h4>
            <span class="restaurant__info-content-location">
                <i class="fas fa-map-marker-alt"></i>{{ __(@$restaurant->location->name) }}
            </span>
            <div class="restaurant__info-content-meta d-flex align-items-center justify-content-between flex-wrap">
                <ul class="restaurant__info-content-meta-left">
                    <li><i class="las la-clock"></i>{{ $restaurant->delivery_time }} @lang('Mins')</li>
                    <li><i class="las la-biking"></i>{{ showAmount($restaurant->delivery_charge) }}
                    </li>
                </ul>
                <div class="restaurant__info-content-meta-right text-end">
                    <span><i class="las la-star"></i></span> <span>({{ $restaurant->averageRating() }}.0)</span>
                </div>
            </div>
        </div>
    </div>
</div>
