@extends('admin.layouts.app')
@section('panel')
    <div class="row">
        <div class="col-xl-12">
            <div class="card">
                <form class="notify-form">
                    @csrf
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label>@lang('Being Sent') </label>
                                    <div class="input-group">
                                        <span class="input-group-text">@lang('To')</span>
                                        <select class="form-control" name="being_sent_to" required>
                                            @foreach ($notifyToRestaurant as $key => $toRestaurant)
                                                <option value="{{ $key }}">{{ __($toRestaurant) }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                                <div class="input-append"></div>
                            </div>

                            <div class="col-md-12">
                                <div class="form-group">
                                    <label>@lang('Subject') </label>
                                    <input class="form-control" name="subject" type="text"
                                        placeholder="@lang('Email subject')" required />
                                </div>
                            </div>
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label>@lang('Message') </label>
                                    <textarea class="form-control nicEdit" name="message" rows="10"></textarea>
                                </div>
                            </div>

                            <div class="col-md-12">
                                <div class="row">
                                    <div class="col-md-4 start-from-col">
                                        <div class="form-group">
                                            <label>@lang('Start Form') </label>
                                            <input class="form-control" name="start_form" type="number"
                                                placeholder="@lang('Start form restaurant')" required />
                                        </div>
                                    </div>
                                    <div class="col-md-4 per-batch-col">
                                        <div class="form-group">
                                            <label>@lang('Per Batch') </label>
                                            <div class="input-group">
                                                <input class="form-control" name="batch" type="number"
                                                    placeholder="@lang('How many restaurant')" required />
                                                <span class="input-group-text">
                                                    @lang('Restaurant')
                                                </span>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-4 cooling-period-col">
                                        <div class="form-group">
                                            <label>@lang('Cooling Period') </label>
                                            <div class="input-group">
                                                <input class="form-control" name="cooling_time" type="number"
                                                    placeholder="@lang('Waiting time')" required />
                                                <span class="input-group-text">
                                                    @lang('Seconds')
                                                </span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="card-footer">
                        <button class="btn w-100 h-45 btn--primary me-2" type="submit">@lang('Submit')</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <div class="modal fade" id="notificationSending" data-bs-backdrop="static">
        <div class="modal-dialog modal-lg modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">@lang('Notification Sending')</h5>
                </div>
                <div class="modal-body">
                    <h4 class="text--danger dontCloseWarning text-center">@lang('Don\'t close or refresh the window till finish.')</h4>

                    <div class="mail-wrapper">
                        <div class="sendingIcon mail-icon world-icon"><i class="las la-globe"></i></div>
                        <div class="coolingIcon mail-icon world-icon"><i class="fas fa-spinner fa-spin"></i></div>
                        <div class='sendingIcon mailsent'>
                            <div class='envelope'>
                                <i class='line line1'></i>
                                <i class='line line2'></i>
                                <i class='line line3'></i>
                                <i class="icon fa fa-envelope"></i>
                            </div>
                        </div>
                        <div class="sendingIcon mail-icon mail-icon"><i class="las la-envelope-open-text"></i></div>
                    </div>
                    <div class="finalStatistics d-none">
                        <div class="mail-icon text--success fw-bold text-center">
                            <i class="fas fa-check"></i> @lang('Done')
                        </div>
                        <ul class="list-group">
                            <li class="list-group-item d-flex justify-content-between align-items-center">
                                @lang('Start From')<span class="fw-bold startFrom">0</span>
                            </li>
                            <li class="list-group-item d-flex justify-content-between align-items-center">
                                @lang('Ended at')<span class="fw-bold sent">0</span>
                            </li>
                        </ul>
                    </div>
                    <h4 class="text--primary remainingTime d-none text-center"></h4>

                    <div class="mt-3">
                        <p class="sentStatistics text-center mb-2">@lang('Email sent') <span class="startFrom">0</span>
                            @lang('to') <span class="sent">-</span> @lang('restaurants')
                        </p>
                        <p class="text-center sentStatistics">
                            <button class="btn btn--danger stopSending"><i
                                    class="la la-power-off"></i>@lang('Stop')</button>
                        </p>
                        <div class="modelCloseButton d-none text-end">
                            <button class="btn btn--danger" data-bs-dismiss="modal" type="button" aria-label="Close">
                                @lang('Close')
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('breadcrumb-plugins')
    <span class="text--primary">@lang('Notification will send via ') @if (gs('en'))
            <span class="badge badge--warning">@lang('Email')</span>
            @endif @if (gs('sn'))
                <span class="badge badge--warning">@lang('SMS')</span>
            @endif
    </span>
@endpush

@push('style')
    <style>
        .coolingIcon {
            margin: 0 auto;
        }
    </style>
@endpush

@push('script')
    <script>
        (function($) {
            "use strict"

            var subject = null,
                message = null,
                start = null,
                perBatch = null,
                sendingStatus = true,
                coolingTime = null,
                being_sent_to = null,
                _token = null,
                restaurant = null,
                number_of_top_deposited_restaurant,
                number_of_days
            $('.notify-form').on('submit', function(e) {
                subject = $(this).find('[name=subject]').val();
                being_sent_to = $(this).find('[name=being_sent_to]').val();
                message = $(this).find('.nicEdit-main').html();
                start = parseInt($(this).find('[name=start_form]').val());
                perBatch = parseInt($(this).find('[name=batch]').val());
                coolingTime = parseInt($(this).find('[name=cooling_time]').val());
                restaurant = $(".input-append").find(`#restaurant_list`).val();

                number_of_top_deposited_restaurant = $(".input-append").find(
                    'input[name=number_of_top_deposited_restaurant]').val();
                number_of_days = $(".input-append").find('input[name=number_of_days]').val();
                _token = $(this).find('[name=_token]').val();

                if ({{ $restaurants }} <= 0) {
                    notify('error', 'Restaurants not found');
                    return false;
                }
                if (!coolingTime) {
                    notify('error', `@lang('Cooling period must be greater then zero')`);
                    return false;
                }
                if (!perBatch) {
                    notify('error', `@lang('Per batch must be greater then zero')`);
                    return false;
                }
                e.preventDefault();
                sendingStatus = true;
                $('.progress-bar').css('width', `0%`);
                $('.progress-bar').text(`0%`);
                $('.sent').text('-');
                $('.stopSending,.dontCloseWarning,.sentStatistics').removeClass('d-none');
                $('.finalStatistics,.modelCloseButton').addClass('d-none');
                $('#notificationSending').modal('show');

                $('.startFrom').text(start);
                postMail();
            });

            function postMail() {
                if (!sendingStatus) {
                    $('.remainingTime,.coolingIcon,.dontCloseWarning,.sentStatistics').addClass('d-none')
                    $('.finalStatistics,.modelCloseButton').removeClass('d-none');
                    return;
                }
                $('.remainingTime').text('Cooling...')
                $('.remainingTime,.coolingIcon').addClass('d-none')
                $('.sendingIcon').removeClass('d-none')
                $.post("{{ route('admin.restaurants.notification.all.send') }}", {
                    "subject": subject,
                    "_token": _token,
                    "start": start,
                    "batch": perBatch,
                    "message": message,
                    'being_sent_to': being_sent_to,
                    'restaurant': restaurant,
                    'number_of_top_deposited_restaurant': number_of_top_deposited_restaurant,
                    'number_of_days': number_of_days,
                }, function(response) {
                    $('.remainingTime').removeClass('d-none')
                    $('.sendingIcon').addClass('d-none')
                    $('.coolingIcon').removeClass('d-none')
                    if (response.error) {
                        response.error.forEach(error => {
                            notify('error', error)
                        });
                    } else {
                        start += parseInt(response.total_sent);
                        $('.sent').text(start);
                        if (!parseInt(response.total_sent)) {
                            sendingStatus = false;
                            postMail();
                            return;
                        }
                        $('.sentStatistics').removeClass('d-none');
                        setTimeout(function() {
                            clearInterval(interval)
                            postMail();
                        }, coolingTime * 1000);
                        var counter = coolingTime - 1,
                            interval = setInterval(function() {
                                $('.remainingTime').text("Reloading after " + counter + " seconds");
                                counter--;
                                if (counter <= 0) clearInterval(interval);
                            }, 1000);
                    }
                });
            }

            $('.stopSending').on('click', function() {
                sendingStatus = false;
                notify('info', `@lang('Notification sending will stop after this batch.')`);
                $('.sentStatistics').addClass('d-none')
            });

            $('select[name=being_sent_to]').on('change', function(e) {
                let methodName = $(this).val();
                methodName = methodName.toUpperCase();
                if (methodName == 'SELECTEDRESTAURANTS') {
                    $('.input-append').html(`
                    <div class="form-group" id="restaurant_list_wrapper">
                        <label class="required">@lang('Select Restaurant')</label>
                        <select name="restaurant[]"  class="form-control" id="restaurant_list" required multiple>
                            <option disabled>@lang('Select One')</option>
                        </select>
                    </div>
                    `);

                    fetchRestaurantList();
                    changeEmailSendingOptionHtml(true);
                    return;
                }

                if (methodName == 'TOPDEPOSITEDRESTAURANTS') {
                    $('.input-append').html(`
                    <div class="form-group">
                        <label class="required">@lang('Number Of Top Deposited Restaurant')</label>
                        <input class="form-control" type="number" name="number_of_top_deposited_restaurant" >
                    </div>
                    `);
                    changeEmailSendingOptionHtml(true);
                    return
                }

                if (methodName == 'NOTLOGINRESTAURANTS') {
                    $('.input-append').html(`
                    <div class="form-group">
                        <label class="required">@lang('Number Of Days')</label>
                        <div class="input-group">
                            <input class="form-control" type="number" name="number_of_days" >
                            <span class="input-group-text">@lang('Days')</span>
                        </div>
                    </div>
                    `);
                    changeEmailSendingOptionHtml(true);
                    return
                }

                $('.input-append').empty();
                changeEmailSendingOptionHtml();

            });

            function fetchRestaurantList() {
                $('.row #restaurant_list').select2({
                    ajax: {
                        url: "{{ route('admin.restaurants.list') }}",
                        type: "get",
                        dataType: 'json',
                        delay: 1000,
                        data: function(params) {
                            return {
                                search: params.term,
                                page: params.page,
                            };
                        },
                        processResults: function(response, params) {
                            params.page = params.page || 1;
                            let data = response.restaurants.data;
                            return {
                                results: $.map(data, function(item) {
                                    return {
                                        text: item.email,
                                        id: item.id
                                    }
                                }),
                                pagination: {
                                    more: response.more
                                }
                            };
                        },
                        cache: false,
                    },
                    dropdownParent: $('.input-append #restaurant_list_wrapper')
                });
            }

            function changeEmailSendingOptionHtml(change = true) {
                if (change) {
                    $('.start-from-col').addClass('d-none');
                    $('.cooling-period-col').addClass('col-lg-6').removeClass('.col-md-4');
                    $('.per-batch-col').addClass('col-lg-6').removeClass('.col-md-4');
                    $('input[name=start_form]').attr('required', false).val(0);
                    return;
                }
                $('.start-from-col').removeClass('d-none');
                $('.cooling-period-col').removeClass('col-lg-6').addClass('col-md-4');
                $('.per-batch-col').removeClass('col-lg-6').addClass('col-md-4');
                $('input[name=start_form]').attr('required', true);
            }

        })(jQuery);
    </script>
@endpush

@push('style')
    <style>
        #restaurant_list_wrapper {
            position: relative
        }
    </style>
@endpush
