@extends('admin.layouts.app')

@section('panel')
    <div class="row">
        <div class="col-lg-12">
            <div class="card b-radius--10 ">
                <div class="card-body p-0">
                    <div class="table-responsive--md table-responsive">
                        <table class="table table--light style--two">
                            <thead>
                                <tr>
                                    <th>@lang('Restaurant')</th>
                                    <th>@lang('Foods')</th>
                                    <th>@lang('Email-Phone')</th>
                                    <th>@lang('Location')</th>
                                    <th>@lang('Joined At')</th>
                                    <th>@lang('Balance')</th>
                                    <th>@lang('Featured')</th> <!-- Added Featured Column -->
                                    <th>@lang('Action')</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($restaurants as $restaurant)
                                    <tr>
                                        <td>
                                            <div class="user">
                                                <div class="thumb me-2">
                                                    <img src="{{ getImage(getFilePath('restaurantProfile') . '/' . @$restaurant->profile_image, getFileSize('restaurantProfile')) }}"
                                                        alt="{{ __($restaurant->restaurant_name) }}" class="plugin_bg">
                                                </div>
                                                <div>
                                                    <span class="fw-bold">{{ $restaurant->restaurant_name }}</span><br>
                                                    <span class="small">
                                                        <a href="{{ route('admin.restaurants.detail', $restaurant->id) }}">
                                                            <span>@</span>{{ $restaurant->username }}
                                                        </a>
                                                    </span>
                                                </div>
                                            </div>
                                        </td>

                                        <td>
                                            <a href="{{ route('admin.foods.index', ['search' => $restaurant->restaurant_name]) }}"
                                                title="View Foods">
                                                {{ $restaurant->foods_count }}
                                            </a>
                                        </td>
                                        <td>{{ $restaurant->email }}<br>{{ $restaurant->mobile }}</td>
                                        <td>
                                            <span class="fw-bold">{{ __(@$restaurant->location->name) }}</span>
                                        </td>
                                        <td>
                                            {{ showDateTime($restaurant->created_at) }} <br>
                                            {{ diffForHumans($restaurant->created_at) }}
                                        </td>
                                        <td>
                                            <span class="fw-bold">
                                                {{ showAmount($restaurant->balance) }}
                                            </span>
                                        </td>
                                        <td>@php echo $restaurant->featuredBadge @endphp</td>
                                        <td>
                                            <div class="button--group">
                                                @if ($restaurant->is_featured)
                                                    <button class="btn btn-sm btn-outline--danger confirmationBtn"
                                                        data-question="@lang('Are you sure not to feature this restaurant?')"
                                                        data-action="{{ route('admin.restaurants.featured', $restaurant->id) }}">
                                                        <i class="la la-eye-slash"></i> @lang('Unfeature')
                                                    </button>
                                                @else
                                                    <button class="btn btn-sm btn-outline--success confirmationBtn"
                                                        data-question="@lang('Are you sure to feature this restaurant?')"
                                                        data-action="{{ route('admin.restaurants.featured', $restaurant->id) }}">
                                                        <i class="la la-eye"></i> @lang('Feature')
                                                    </button>
                                                @endif
                                                <a href="{{ route('admin.restaurants.detail', $restaurant->id) }}"
                                                    class="btn btn-sm btn-outline--primary">
                                                    <i class="las la-desktop"></i> @lang('Details')
                                                </a>
                                                @if (request()->routeIs('admin.restaurants.kyc.pending'))
                                                    <a href="{{ route('admin.restaurants.kyc.details', $restaurant->id) }}"
                                                        target="_blank" class="btn btn-sm btn-outline--dark">
                                                        <i class="las la-user-check"></i>@lang('KYC Data')
                                                    </a>
                                                @endif
                                            </div>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td class="text-muted text-center" colspan="100%">{{ __($emptyMessage) }}</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table><!-- table end -->
                    </div>
                </div>
                @if ($restaurants->hasPages())
                    <div class="card-footer py-4">
                        {{ paginateLinks($restaurants) }}
                    </div>
                @endif
            </div>
        </div>
    </div>

    <x-confirmation-modal />
@endsection

@push('breadcrumb-plugins')
    <x-search-form placeholder="Username / Email" />
@endpush
