@extends('admin.layouts.app')

@section('panel')
    <div class="row">
        <div class="col-lg-12">
            <div class="card b-radius--10 ">
                <div class="card-body p-0">
                    <div class="table-responsive--md  table-responsive">
                        <table class="table table--light style--two sortable-table">
                            <thead>
                                <tr>
                                    <th>@lang('Name')</th>
                                    <th>@lang('Price')</th>
                                    <th>@lang('Time')</th>
                                    <th>@lang('Status')</th>
                                    <th>@lang('Action')</th>
                                </tr>
                            </thead>
                            <tbody class="sort">
                                @forelse($plans as $plan)
                                    <tr class="sortable-table-row" data-id="{{ $plan->id }}">
                                        <td>{{ __($plan->name) }}</td>
                                        <td>{{ showAmount($plan->price) }}</td>
                                        <td>{{ __($plan->time) }} @lang('Days')</td>
                                        <td> @php echo $plan->statusBadge; @endphp </td>
                                        <td>
                                            <div class="button--group">
                                                <button type="button" data-id="{{ $plan->id }}"
                                                    data-name      = "{{ $plan->name }}"
                                                    data-time      = "{{ $plan->time }}"
                                                    data-price     = "{{ $plan->price }}"
                                                    data-route     = "{{ route('admin.plan.store', $plan->id) }}"
                                                    data-bs-toggle = "modal" data-bs-target = "#planModal"
                                                    class="btn btn-outline--primary editBtn btn-sm"><i
                                                        class="las la-pen"></i>@lang('Edit')</button>

                                                @if ($plan->status == Status::DISABLE)
                                                    <button class="btn btn-sm btn-outline--success confirmationBtn"
                                                        data-question = "@lang('Are you sure to enable this plan?')"
                                                        data-action   = "{{ route('admin.plan.status', $plan->id) }}"><i
                                                            class="la la-eye"></i>@lang('Enable')
                                                    </button>
                                                @else
                                                    <button class="btn btn-sm btn-outline--danger confirmationBtn"
                                                        data-question="@lang('Are you sure to disable this plan?')"
                                                        data-action="{{ route('admin.plan.status', $plan->id) }}"><i
                                                            class="la la-eye-slash"></i>@lang('Disable')
                                                    </button>
                                                @endif

                                            </div>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td class="text-muted text-center" colspan="100%">{{ __($emptyMessage) }}</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table><!-- table end -->
                    </div>
                </div>
                @if ($plans->hasPages())
                    <div class="card-footer py-4">
                        {{ paginateLinks($plans) }}
                    </div>
                @endif
            </div><!-- card end -->
        </div>
    </div>

    <div class="modal fade" id="planModal">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title">@lang('Add New plan')</h4>
                    <button type="button" class="close" data-bs-dismiss="modal"><span><i
                                class="las la-times"></i></span></button>
                </div>
                <form method="post" action="{{ route('admin.plan.store') }}" enctype="multipart/form-data">
                    @csrf
                    <div class="modal-body">
                        <div class="form-group">
                            <label>@lang('Name') </label>
                            <input type="text" class="form-control" name="name" required>
                        </div>
                        <div class="form-group">
                            <label>@lang('Time')</label>
                            <div class="input-group">
                                <input type="text" class="form-control" name="time" value="">
                                <span class="input-group-text">@lang('Days')</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <label>@lang('Price')</label>
                            <div class="input-group">
                                <input type="text" class="form-control" name="price" value="">
                                <span class="input-group-text">{{ gs('cur_sym') }}</span>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn--primary w-100 h-45"><i class="fa fa-send"></i>
                            @lang('Submit')</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <x-confirmation-modal />
@endsection

@push('breadcrumb-plugins')
    <button type="button" data-route="{{ route('admin.plan.store') }}" data-bs-target="#planModal" data-bs-toggle="modal"
        class="btn btn-sm btn-outline--primary addBtn"><i class="las la-plus"></i>@lang('Add New')</button>
@endpush

@push('style-lib')
    <link rel="stylesheet" href="{{ asset('assets/admin/css/table-sortable.css') }}">
@endpush

@push('script-lib')
    <script src="{{ asset('assets/admin/js/jquery-ui.js') }}"></script>
    <script src="{{ asset('assets/admin/js/table-sortable.js') }}"></script>
@endpush

@push('script')
    <script>
        $(function($) {
            "use strict";
            var modal = $('#planModal');

            $('.editBtn').on('click', function() {
                modal.find('form')[0].reset();
                modal.find('form').attr('action', $(this).data('route'));
                modal.find('input[name=name]').val($(this).data('name'));
                modal.find('input[name=time]').val($(this).data('time'));
                modal.find('input[name=price]').val($(this).data('price'));
            });

            $('.addBtn').on('click', function() {
                modal.find('form')[0].reset();
                modal.find('form').attr('action', $(this).data('route'));
            });

        });
    </script>
@endpush


@push('script')
    <script>
        function updateSortOrder(sorting) {
            var action = "{{ route('admin.plan.sort') }}";
            var csrf = "{{ csrf_token() }}";
            sortOrderAction(sorting, action, csrf);
        }
    </script>
@endpush
