@extends('admin.layouts.app')
@section('panel')
    <div class="row">
        <div class="col-lg-12">
            <div class="card b-radius--10 ">
                <div class="card-body p-0">
                    <div class="table-responsive--md  table-responsive">
                        <table class="table table--light style--two">
                            <thead>
                                <tr>
                                    <th>@lang('User')</th>
                                    <th>@lang('Restaurant')</th>
                                    <th>@lang('Address')</th>
                                    <th>@lang('Total Price')</th>
                                    <th>@lang('Payment Type')</th>
                                    <th>@lang('Status')</th>
                                    <th>@lang('Action')</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($orders as $order)
                                    <tr>
                                        <td>
                                            <span class="fw-bold">{{ $order->user->username }}</span>
                                            <br>
                                            <span class="small">
                                                <a
                                                    href="{{ route('admin.users.detail', $order->user->id) }}"><span>@</span>{{ $order->user->username }}</a>
                                            </span>
                                        </td>

                                        <td>
                                            <span class="fw-bold">{{ $order->restaurant->restaurant_name }}</span>
                                            <br>
                                            <span class="small">
                                                <a
                                                    href="{{ route('admin.restaurants.detail', $order->restaurant->id) }}"><span>@</span>{{ $order->restaurant->username }}</a>
                                            </span>
                                        </td>


                                        <td>
                                            {{ __(strLimit($order->address, 17)) }}
                                        </td>

                                        <td>
                                            <div>
                                                {{ showAmount($order->total_price) }} <br>
                                                <small
                                                    class="text--primary">{{ showDateTime($order->created_at, 'd/m/y @ h A') }}</small>
                                            </div>
                                        </td>

                                        <td>
                                            @php echo $order->typeBadge @endphp
                                        </td>

                                        <td>
                                            @php echo $order->statusBadge @endphp
                                        </td>

                                        <td>
                                            <div class="button--group">
                                                <a href="{{ route('admin.orders.details', $order->id) }}"
                                                    class="btn btn-sm btn-outline--primary">
                                                    <i class="las la-desktop"></i> @lang('Details')
                                                </a>
                                            </div>
                                        </td>

                                    </tr>
                                @empty
                                    <tr>
                                        <td class="text-muted text-center" colspan="100%">{{ __($emptyMessage) }}</td>
                                    </tr>
                                @endforelse

                            </tbody>
                        </table><!-- table end -->
                    </div>
                </div>
                @if ($orders->hasPages())
                    <div class="card-footer py-4">
                        {{ paginateLinks($orders) }}
                    </div>
                @endif
            </div>
        </div>
    </div>
@endsection

@push('breadcrumb-plugins')
    <x-search-form placeholder="User Username / Restaurant Name" />
@endpush
