@extends('admin.layouts.app')
@section('panel')
    <div class="row mb-none-30 justify-content-center">
        <div class="col-xl-4 col-md-6 mb-30">
            @if ($food->variations_count)
                <div class="card b-radius--10 overflow-hidden box--shadow1 mt-2">
                    <div class="card-body">
                        <h5 class="mb-20 text-muted">@lang('Variants')</h5>
                        <div class="accordion custom--accordion">
                            @foreach (@$food->variations ?? [] as $variant)
                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="faqHeading{{ $loop->iteration }}">
                                        <button class="accordion-button @if (!$loop->first) collapsed @endif"
                                            type="button" data-bs-toggle="collapse"
                                            data-bs-target="#faqCollapse{{ $loop->iteration }}"
                                            @if ($loop->first) aria-expanded="true"
                                            @else
                                            aria-expanded="false" @endif
                                            aria-controls="faqCollapse{{ $loop->iteration }}">
                                            <span>{{ $variant->title }}</span>
                                        </button>
                                    </h2>
                                    <div id="faqCollapse{{ $loop->iteration }}"
                                        class="accordion-collapse collapse @if ($loop->first) show @endif"
                                        aria-labelledby="faqHeading{{ $loop->iteration }}"
                                        data-bs-parent="#accordionExample">
                                        <div class="accordion-body">
                                            @foreach (@$variant->items ?? [] as $item)
                                                <div class="food-info-wrapper">
                                                    <div class="food-info-group">
                                                        <h6>@lang('Name'):</h6>
                                                        <p>{{ $item->name }}</p>
                                                    </div>

                                                    <div class="food-info-group">
                                                        <h6>@lang('Price'):</h6>
                                                        <p>{{ showAmount($item->price) }}</p>
                                                    </div>
                                                </div>
                                                @if (!$loop->last)
                                                @endif()
                                            @endforeach
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    </div>
                </div>
            @endif

            @if ($food->addons_count)
                <div class="card b-radius--10 overflow-hidden box--shadow1 mt-2">
                    <div class="card-body">
                        <h5 class="card-title  border-bottom mb-3 text-muted">@lang('Addons')</h5>
                        @foreach (@$food->addons ?? [] as $addon)
                            <div class="food-info-wrapper">
                                <div class="food-info-group">
                                    <h6>@lang('Name'):</h6>
                                    <p>{{ $addon->name }}</p>
                                </div>

                                <div class="food-info-group">
                                    <h6>@lang('Price'):</h6>
                                    <p>{{ showAmount($addon->price) }}</p>
                                </div>
                            </div>
                            @if (!$loop->last)
                            @endif()
                        @endforeach
                    </div>
                </div>
            @endif


        </div>
        <div
            @if (!$food->variations_count && !$food->addons_count) class="col-xl-12 col-md-12 mb-30" @else class="col-xl-8 col-md-6 mb-30" @endif>
            <div class="card b-radius--10 overflow-hidden box--shadow1 mb-3">
                <div class="card-body">
                    <h5 class="card-title  border-bottom mb-3 text-muted">@lang('Info')</h5>
                    <div class="food-info-group">
                        <h6 for="">@lang('Name'):</h6>
                        <p class="mb-3">{{ $food->name }}</p>
                    </div>
                    <div class="food-info-group">
                        <h6 for="">@lang('Restaurant Name'):</h6>
                        <a
                            href="{{ route('admin.restaurants.detail', $food->restaurant->id) }}">{{ $food->restaurant->restaurant_name }}</a>
                    </div>
                    <div class="food-info-group">
                        <h6 for="">@lang('Description'):</h6>
                        <p>{{ @$food->short_description }}</p>
                    </div>
                    <div class="food-info-group">
                        <h6 for="">@lang('Price'):</h6>
                        <p>{{ showAmount($food->price) }}</p>
                    </div>
                    <div class="food-info-group">
                        <h6 for="">@lang('Categories'):</h6>
                        <p>
                            @foreach ($food->categories as $category)
                                {{ @$category->name }} @if (!$loop->last)
                                    ,
                                @endif
                            @endforeach
                        </p>
                    </div>
                </div>
            </div>

            <div class="card b-radius--10 overflow-hidden box--shadow1 mb-3">
                <div class="card-body">
                    <h5 class="card-title border-bottom pb-2 text-muted">@lang('Cover Photo')</h5>
                    <div class="d-flex justify-content-center">
                        <img class="rounded-3"
                            src="{{ getImage(getFilePath('food') . '/' . $food->image, getFileSize('food')) }}"
                            alt="no image found">
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
