<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Transaction extends Model
{
    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function restaurant()
    {
        return $this->belongsTo(Restaurant::class);
    }

    public function scopeUserTransaction($query)
    {
        return $query->where('user_id', '!=', 0);
    }

    public function scopeRestaurantTransaction($query)
    {
        return $query->where('restaurant_id', '!=', 0);
    }
}
