<?php

namespace App\Models;

use App\Constants\Status;
use App\Traits\GlobalStatus;
use Illuminate\Database\Eloquent\Casts\Attribute;
use Illuminate\Database\Eloquent\Model;

class Food extends Model
{
    use GlobalStatus;


    public function categories()
    {
        return $this->belongsToMany(Category::class);
    }

    public function restaurant()
    {
        return $this->belongsTo(Restaurant::class);
    }

    public function variations()
    {
        return $this->hasMany(Variant::class);
    }

    public function addons()
    {
        return $this->hasMany(Addon::class);
    }

    public function scopePublished($query)
    {
        return $query->where('status', Status::FOOD_PUBLISHED);
    }

    public function scopeDraft($query)
    {
        return $query->where('status', Status::FOOD_DRAFT);
    }
    public function statusBadge(): Attribute
    {
        return new Attribute(function () {
            $html = '';
            if ($this->status == Status::FOOD_PUBLISHED) {
                $html = '<span class="badge badge--success">' . trans('Published') . '</span>';
            }
            if ($this->status == Status::FOOD_DRAFT) {
                $html = '<span class="badge badge--warning">' . trans('Draft') . '</span>';
            }

            return $html;
        });
    }
}
