<?php

namespace App\Http\Controllers\Restaurant;

use App\Http\Controllers\Controller;
use App\Traits\SupportTicketManager;

class TicketController extends Controller
{
    use SupportTicketManager;

    public function __construct()
    {
        parent::__construct();
        $this->layout       = 'frontend';
        $this->redirectLink = 'restaurant.ticket.view';
        $this->userType     = 'restaurant';
        $this->column       = 'restaurant_id';
        $this->user         = authRestaurant();
        if ($this->user) {
            $this->layout = 'master';
        }
    }
}
