<?php

namespace App\Http\Controllers\Restaurant;

use App\Constants\Status;
use App\Http\Controllers\Controller;
use App\Models\Plan;
use App\Models\Transaction;
use Illuminate\Http\Request;
use Carbon\Carbon;

class PlanController extends Controller
{
    public function index()
    {
        $pageTitle = 'Plans';
        $plans = Plan::active()->orderBy('sort_order')->paginate(getPaginate());
        return view('Template::restaurant.plan.index', compact('pageTitle', 'plans'));
    }

    public function purchase(Request $request, $id = 0)
    {
        $plan = Plan::active()->find($id);
        if (!$plan) return returnBack('Plan not found');
        $restaurant = authRestaurant();

        //if restaurant has already purchased this plan and plan has not been expired
        if (!isPlanExpired($plan)) return returnBack('This plan is already been running');
        if ($restaurant->balance < $plan->price) return returnBack('You do not have enough balance, please deposit funds to purchase this plan');

        $restaurant->plan_id = $plan->id;
        $restaurant->plan_purchased_at = now();
        $restaurant->balance -= $plan->price;
        $restaurant->save();


        $transaction = new Transaction();
        $transaction->restaurant_id = $restaurant->id;
        $transaction->amount = $plan->price;
        $transaction->post_balance = $restaurant->balance;
        $transaction->charge = 0;
        $transaction->trx_type = '-';
        $transaction->details = "Payment Completed for purchasing plan " . $plan->name;
        $transaction->trx = getTrx();
        $transaction->remark = 'plan_purchase';
        $transaction->save();

        return returnBack('Plan purchased successfully', 'success');
    }
}
