<?php

namespace App\Http\Controllers;

use App\Constants\Status;
use App\Lib\CurlRequest;
use App\Models\CronJob;
use App\Models\CronJobLog;
use App\Models\Order;
use App\Models\Transaction;
use Carbon\Carbon;

class CronController extends Controller
{
    public function cron()
    {
        $general            = gs();
        $general->last_cron = now();
        $general->save();

        $crons = CronJob::with('schedule');

        if (request()->alias) {
            $crons->where('alias', request()->alias);
        } else {
            $crons->where('next_run', '<', now())->where('is_running', Status::YES);
        }
        $crons = $crons->get();
        foreach ($crons as $cron) {
            $cronLog              = new CronJobLog();
            $cronLog->cron_job_id = $cron->id;
            $cronLog->start_at    = now();
            if ($cron->is_default) {
                $controller = new $cron->action[0];
                try {
                    $method = $cron->action[1];
                    $controller->$method();
                } catch (\Exception $e) {
                    $cronLog->error = $e->getMessage();
                }
            } else {
                try {
                    CurlRequest::curlContent($cron->url);
                } catch (\Exception $e) {
                    $cronLog->error = $e->getMessage();
                }
            }
            $cron->last_run = now();
            $cron->next_run = now()->addSeconds($cron->schedule->interval);
            $cron->save();

            $cronLog->end_at = $cron->last_run;

            $startTime         = Carbon::parse($cronLog->start_at);
            $endTime           = Carbon::parse($cronLog->end_at);
            $diffInSeconds     = $startTime->diffInSeconds($endTime);
            $cronLog->duration = $diffInSeconds;
            $cronLog->save();
        }
        if (request()->target == 'all') {
            $notify[] = ['success', 'Cron executed successfully'];
            return back()->withNotify($notify);
        }
        if (request()->alias) {
            $notify[] = ['success', keyToTitle(request()->alias) . ' executed successfully'];
            return back()->withNotify($notify);
        }
    }

    public function completeDeliveredOrders()
    {
        // Calculate the date one day ago
        $dateOneDayAgo = Carbon::now()->subDays(1)->toDateString();

        // Retrieve orders created one day ago or more
        $orders = Order::where('status', Status::ORDER_DELIVERED)
            ->whereDate('created_at', '<=', $dateOneDayAgo)
            ->limit(100)
            ->get();

        foreach ($orders as $order) {
            $order->status = Status::ORDER_COMPLETED;
            $order->save();
            $restaurant    = $order->restaurant;
            $trx           = getTrx();


            if ($order->payment_type == Status::PAYMENT_CASH_ON_DELIVERY) {
                //if cash on delivery substract the charge from restaurant balance
                $codCharge = $order->total_price * (gs('cod_percent_charge') / 100) + gs('cod_fixed_charge');
                $restaurant->balance -= $codCharge;
                $restaurant->save();

                $transaction                = new Transaction();
                $transaction->restaurant_id = $restaurant->id;
                $transaction->amount        = $codCharge;
                $transaction->post_balance  = $restaurant->balance;
                $transaction->charge        = 0;
                $transaction->trx_type      = '-';
                $transaction->details       = "Cash on Delivery charge";
                $transaction->trx           = $trx;
                $transaction->remark        = 'cod_charge';
                $transaction->save();
            } else {
                //pay to restaurant as user paid (online) through payment gateway
                $restaurant->balance += $order->total_price;
                $restaurant->save();

                $transaction                = new Transaction();
                $transaction->restaurant_id = $order->restaurant_id;
                $transaction->amount        = $order->total_price;
                $transaction->post_balance  = $restaurant->balance;
                $transaction->charge        = 0;
                $transaction->trx_type      = '+';
                $transaction->details       = "Payment Completed for order";
                $transaction->trx           = $trx;
                $transaction->remark        = 'order_completed';
                $transaction->save();
            }

            notifyUser('user', 'ORDER_COMPLETED_USER', $order, $trx);
            notifyUser('restaurant', 'ORDER_COMPLETED_RESTAURANT', $order, $trx);
        }
        echo 'Orders completed successfully';
    }
}
