<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Order;

class OrderController extends Controller
{

    public function index()
    {
        $pageTitle = 'All Orders';
        $orders = $this->filterOrders();
        return view('admin.order.index', compact('pageTitle', 'orders'));
    }

    public function initiated()
    {
        $pageTitle = 'Initiated Orders';
        $orders = $this->filterOrders('initiated');
        return view('admin.order.index', compact('pageTitle', 'orders'));
    }

    public function active()
    {
        $pageTitle = 'Active Orders';
        $orders = $this->filterOrders('active');
        return view('admin.order.index', compact('pageTitle', 'orders'));
    }

    public function processing()
    {
        $pageTitle = 'Processing Orders';
        $orders = $this->filterOrders('processing');
        return view('admin.order.index', compact('pageTitle', 'orders'));
    }

    public function onDelivery()
    {
        $pageTitle = 'Ongoing Delivery';
        $orders = $this->filterOrders('onDelivery');
        return view('admin.order.index', compact('pageTitle', 'orders'));
    }

    public function delivered()
    {
        $pageTitle = 'Delivered Orders';
        $orders = $this->filterOrders('delivered');
        return view('admin.order.index', compact('pageTitle', 'orders'));
    }

    public function completed()
    {
        $pageTitle = 'Completed Orders';
        $orders = $this->filterOrders('completed');
        return view('admin.order.index', compact('pageTitle', 'orders'));
    }

    public function cancelled()
    {
        $pageTitle = 'Cancelled Orders';
        $orders = $this->filterOrders('cancelled');
        return view('admin.order.index', compact('pageTitle', 'orders'));
    }

    public function details($id)
    {
        $pageTitle = 'Order details';
        $order = Order::with('items', 'items.food')->findOrFail($id);
        return view('admin.order.details', compact('pageTitle', 'order'));
    }

    protected function filterOrders($scope = null)
    {
        if ($scope) {
            $orders = Order::$scope();
        } else {
            $orders = Order::query();
        }

        return $orders->with('restaurant', 'user', 'address')->latest()->searchable(['user:username', 'restaurant:restaurant_name'])->paginate(getPaginate());
    }
}
