<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Form;
use App\Lib\FormProcessor;
use Illuminate\Http\Request;

class KycController extends Controller
{
    public function settingUser()
    {
        $pageTitle = $this->form('user')[0];
        $form      = $this->form('user')[1];
        return view('admin.kyc.setting', compact('pageTitle', 'form'));
    }

    public function settingRestaurant()
    {
        $pageTitle = $this->form('restaurant')[0];
        $form      = $this->form('restaurant')[1];
        return view('admin.kyc.setting', compact('pageTitle', 'form'));
    }

    public function form($type)
    {
        $pageTitle = ucfirst($type) . ' KYC Setting';
        $form      = Form::where('act', $type . '_kyc')->first();
        return [$pageTitle, $form];
    }

    public function settingUpdate(Request $request, $type)
    {
        $formProcessor = new FormProcessor();
        $generatorValidation = $formProcessor->generatorValidation();
        $request->validate($generatorValidation['rules'], $generatorValidation['messages']);
        $exist = Form::where('act', $type . '_kyc')->first();
        $formProcessor->generate($type . '_kyc', $exist, 'act');

        $notify[] = ['success', 'KYC data updated successfully'];
        return back()->withNotify($notify);
    }
}
