<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Food;

class FoodController extends Controller
{

    public function index()
    {
        $pageTitle = 'All Foods';
        $foods = $this->filterFoods();
        return view('admin.food.index', compact('pageTitle', 'foods'));
    }

    public function published()
    {
        $pageTitle = 'Published Foods';
        $foods = $this->filterFoods('published');
        return view('admin.food.index', compact('pageTitle', 'foods'));
    }

    public function draft()
    {
        $pageTitle = 'Draft Foods';
        $foods = $this->filterFoods('draft');
        return view('admin.food.index', compact('pageTitle', 'foods'));
    }

    public function details($id)
    {
        $pageTitle = 'Food details';
        $food = Food::with('variations', 'variations.items', 'addons')->withCount('variations', 'addons')->findOrFail($id);
        return view('admin.food.details', compact('pageTitle', 'food'));
    }

    protected function filterFoods($scope = null)
    {
        if ($scope) {
            $foods = Food::$scope();
        } else {
            $foods = Food::query();
        }

        return $foods->latest()
            ->with('restaurant')
            ->withCount('categories')
            ->searchable(['restaurant:restaurant_name'])
            ->paginate(getPaginate());
    }
}
