<?php

namespace App\Http\Controllers\Admin;

use App\Constants\Status;
use App\Http\Controllers\Controller;
use App\Models\Advertisement;
use App\Rules\FileTypeValidate;
use Illuminate\Http\Request;

class AdvertisementController extends Controller
{
    public function index()
    {
        $pageTitle = 'All Advertisements';
        $advertisements = Advertisement::orderBy('id', 'DESC')->paginate(getPaginate());
        return view('admin.advertisement.index', compact('advertisements', 'pageTitle'));
    }


    public function store(Request $request, $id = 0)
    {

        $imgRequired = $id ? 'nullable' : 'required';
        $sizes = adsSizes();
        $request->validate([
            'size'         => 'required|in:' . implode(',', $sizes),
            'redirect_url' => 'nullable|url',
            'image'        => [$imgRequired, 'image', new FileTypeValidate(['jpeg', 'jpg', 'png', 'gif'])],
        ]);

        if ($id) {
            $advertisement = Advertisement::findOrFail($id);
            $notifyMessage = 'Advertisement updated successfully';
        } else {
            $advertisement = new Advertisement();
            $notifyMessage = 'Advertisement created successfully';
        }

        if ($request->image) {
            try {
                $advertisement->value = fileUploader($request->image, getFilePath('advertisement'), $request->size, old: $advertisement->value);
            } catch (\Exception $exp) {
                return returnBack('Couldn\'t upload your image');
            }
        }

        $advertisement->redirect_url = $request->redirect_url ? $request->redirect_url : '';
        $advertisement->size = $request->size;
        $advertisement->save();

        return returnBack($notifyMessage, 'success', route: 'admin.advertisement.index');
    }

    public function status($id)
    {
        return Advertisement::changeStatus($id);
    }
}
