(function ($) {
  ("user strict");

  $(document).ready(function () {
    //preloader
    $(".preloader")
      .delay(300)
      .animate(
        {
          opacity: "0",
        },
        300,
        function () {
          $(".preloader").css("display", "none");
        }
      );
  });

  // tooltip js
  const tooltipTriggerList = document.querySelectorAll(
    '[data-bs-toggle="tooltip"]'
  );
  const tooltipList = [...tooltipTriggerList].map(
    (tooltipTriggerEl) => new bootstrap.Tooltip(tooltipTriggerEl)
  );
  // tooltip js end

  ////////////////////////////////////////////////////
  // Mobile Menu Js

  $("#mobile-menu").meanmenu({
    meanMenuContainer: ".mobile-menu",
    meanScreenWidth: "1199",
    meanExpand: ['<i class="fal fa-plus"></i>'],
  });

  // side - info
  $(".side-info-close,.offcanvas-overlay").on("click", function () {
    $(".side-info").removeClass("info-open");
    $(".offcanvas-overlay").removeClass("overlay-open");
  });
  $(".side-toggle").on("click", function () {
    $(".side-info").addClass("info-open");
    $(".offcanvas-overlay").addClass("overlay-open");
  });

  // Overlay Event
  var over = $(".overlay");
  over.on("click", function () {
    $(".overlay").removeClass("overlay-color");
    $(".overlay").removeClass("active");
    $(".your-cart").removeClass("active");
  });

  $(document).on("click", ".cross-btn", function () {
    $(".your-cart").removeClass("active");
    $(".sidebar-overlay").removeClass("show");
  });

  // ================== Sidebar Menu Js Start ===============
  // Sidebar Dropdown Menu Start
  $(".has-dropdown > a").on("click", function () {
    $(".sidebar-submenu").slideUp(200);
    if ($(this).parent().hasClass("active")) {
      $(".has-dropdown").removeClass("active");
      $(this).parent().removeClass("active");
    } else {
      $(".has-dropdown").removeClass("active");
      $(this).next(".sidebar-submenu").slideDown(200);
      $(this).parent().addClass("active");
    }
  });
  // Sidebar Dropdown Menu End
  // Sidebar Icon & Overlay js
  $(".sidebar_menu_btn").on("click", function () {
    $(".sidebar-menu").addClass("show");
    $(".sidebar-overlay").addClass("show");
  });
  $(".sidebar-menu__close, .sidebar-overlay").on("click", function () {
    $(".sidebar-menu").removeClass("show");
    $(".your-cart").removeClass("active");
    $(".sidebar-overlay").removeClass("show");
  });
  // Sidebar Icon & Overlay js
  // ===================== Sidebar Menu Js End =================

  // ========================= Header Sticky Js Start ==============
  $(window).on("scroll", function () {
    if ($(window).scrollTop() >= 100) {
      $(".header-main").addClass("header-sticky");
    } else {
      $(".header-main").removeClass("header-sticky");
    }
  });
  // ========================= Header Sticky Js End===================
  // Scroll To Top Event
  var scrollTop = $(".scrollToTop");
  $(window).on("scroll", function () {
    if ($(this).scrollTop() < 500) {
      scrollTop.removeClass("active");
    } else {
      scrollTop.addClass("active");
    }
  });

  // Click event to scroll to top
  $(".scrollToTop").on("click", function () {
    $("html, body").animate(
      {
        scrollTop: 0,
      },
      300
    );
    return false;
  });
  // ========================= Increament & Decreament Js End =====================

  // ========================= Light and Dark Mode start =====================

  // ========================= Light and Dark Mode End =====================

  // ========================= Custom Js =====================
  $(document).ready(function () {
    $(
      ".restaurant__thumb-icon, .restaurant-info-box__meta-rating .fav-icon"
    ).on("click", function (e) {
      e.preventDefault(); // Prevent default link behavior
      var btn = $(this);
      var url = btn.data("url"); // Get the URL from the clicked link
      var buttonsWithSameUrl = $(
        ".restaurant__thumb-icon[data-url='" +
          url +
          "'], .restaurant-info-box__meta-rating .fav-icon[data-url='" +
          url +
          "']"
      );
      $.ajax({
        url: url,
        type: "GET",
        success: function (response) {
          if (response.success) {
            notify("success", response.message);
            buttonsWithSameUrl.toggleClass("active");
          } else {
            notify("error", response.message);
          }
        },
        error: function (xhr, status, error) {
          // Handle error if any
          console.error(xhr.responseText);
        },
      });
    });
  });

  $(document).ready(function () {
    $(".popular-food__item .heart").on("click", function (e) {
      e.preventDefault(); // Prevent default link behavior
      var btn = $(this);
      var url = btn.data("url"); // Get the URL from the clicked link
      var buttonsWithSameUrl = $(
        ".popular-food__item .heart[data-url='" + url + "']"
      );
      $.ajax({
        url: url,
        type: "GET",
        success: function (response) {
          if (response.success) {
            notify("success", response.message);
            buttonsWithSameUrl.toggleClass("active");
          } else {
            notify("error", response.message);
          }
        },
        error: function (xhr, status, error) {
          // Handle error if any
          console.error(xhr.responseText);
        },
      });
    });
  });

  // Sidebar Icon & Overlay js
  $(".event-filter__button").on("click", function () {
    $(".grid-sidebar").addClass("show-sidebar");
    $(".sidebar-overlay").addClass("show");
  });

  $(".side-sidebar-close-btn, .sidebar-overlay").on("click", function () {
    $(".grid-sidebar").removeClass("show-sidebar");
    $(".sidebar-overlay").removeClass("show");
  });

  $(".scrollToTop").on("click", function (e) {
    var $this = $(this);
    $this.toggleClass("clicked");

    setTimeout(function () {
      $this.removeClass("clicked");
    }, 200);
  });

  // image uploader
  function proPicURL(input) {
    if (input.files && input.files[0]) {
      var reader = new FileReader();
      reader.onload = function (e) {
        var preview = $(input)
          .closest(".image-upload-wrapper")
          .find(".image-upload-preview");
        $(preview).css("background-image", "url(" + e.target.result + ")");
        $(preview).addClass("has-image");
        $(preview).hide();
        $(preview).fadeIn(650);
      };
      reader.readAsDataURL(input.files[0]);
    }
  }

  $(".image-upload-input").on("change", function () {
    proPicURL(this);
  });

  $(".remove-image").on("click", function () {
    $(this).parents(".image-upload-preview").css("background-image", "none");
    $(this).parents(".image-upload-preview").removeClass("has-image");
    $(this).parents(".image-upload-wrapper").find("input[type=file]").val("");
  });
  $("form").on("change", ".file-upload-field", function () {
    $(this)
      .parent(".file-upload-wrapper")
      .attr(
        "data-text",
        $(this)
          .val()
          .replace(/.*(\/|\\)/, "")
      );
  });
})(jQuery);
