<?php

use Illuminate\Support\Facades\Route;

Route::get('/clear', function () {
    \Illuminate\Support\Facades\Artisan::call('optimize:clear');
});


Route::get('cron', 'CronController@cron')->name('cron');

// User Support Ticket
Route::controller('TicketController')->prefix('ticket')->name('ticket.')->group(function () {
    Route::get('/', 'supportTicket')->name('index');
    Route::get('new', 'openSupportTicket')->name('open');
    Route::post('create', 'storeSupportTicket')->name('store');
    Route::get('view/{ticket}', 'viewTicket')->name('view');
    Route::post('reply/{id}', 'replyTicket')->name('reply');
    Route::post('close/{id}', 'closeTicket')->name('close');
    Route::get('download/{attachment_id}', 'ticketDownload')->name('download');
});

Route::get('app/deposit/confirm/{hash}', 'Gateway\PaymentController@appDepositConfirm')->name('deposit.app.confirm');

Route::controller('SiteController')->group(function () {
    Route::get('/search', 'search')->name('search');

    Route::get('/food/like/{foodId}', 'setFavoriteFood')->name('food.favorite');
    Route::get('/restaurant/favorite/{restaurantId}', 'setFavoriteRestaurant')->name('restaurant.favorite');

    Route::get('/restaurant/{slug}', 'restaurantDetails')->name('restaurant.details');
    Route::post('/food/add-to-cart', 'addToCart')->name('food.add.cart');
    Route::post('/food/change-quantity', 'changeQuantity')->name('food.cart.quantity');
    Route::post('/food/remove-other-restaurants-food', 'removeOtherRestaurantsFood')->name('food.remove.other.restaurants.food');

    Route::get('/all-restaurants', 'allRestaurants')->name('all.restaurants');
    Route::get('/popular-restaurants', 'popularRestaurants')->name('popular.restaurants');
    Route::get('/top-rated-restaurants', 'topRatedRestaurants')->name('top.rated.restaurants');
    Route::get('/favorite-restaurants', 'favoriteRestaurants')->name('favorite.restaurants');

    Route::get('/category-foods/{slug}', 'categoryFoods')->name('category.foods');

    Route::get('/ad-redirect/{id}', 'SiteController@adRedirect')->name('ad.redirect');

    Route::get('/contact', 'contact')->name('contact');
    Route::post('/contact', 'contactSubmit')->name('contact.submit');
    Route::get('/change/{lang?}', 'changeLanguage')->name('lang');

    Route::get('cookie-policy', 'cookiePolicy')->name('cookie.policy');
    Route::post('/subscribe', 'subscribe')->name('subscribe');
    Route::post('/change-theme', 'changeTheme')->name('change.theme');

    Route::get('/cookie/accept', 'cookieAccept')->name('cookie.accept');

    Route::get('policy/{slug}', 'policyPages')->name('policy.pages');

    Route::get('placeholder-image/{size}', 'placeholderImage')->withoutMiddleware('maintenance')->name('placeholder.image');
    Route::get('maintenance-mode', 'maintenance')->withoutMiddleware('maintenance')->name('maintenance');

    Route::get('/{slug}', 'pages')->name('pages');
    Route::get('/', 'index')->name('home');
});
