@extends($activeTemplate . 'layouts.master')
@section('content')
    @php
        $kycInstruction = getContent('kyc_instruction.content', true);
    @endphp

    <div class="notice"></div>

    @php
        $kyc = getContent('kyc.content', true);
    @endphp
    @if (auth()->user()->kv == Status::KYC_UNVERIFIED && auth()->user()->kyc_rejection_reason)
        <div class="dashboard-widget flex-align alert-danger mb-3">
            <span class="dashboard-widget__icon flex-center"><i class="las la-user-times"></i></span>
            <div class="dashboard-widget__content">
                <h6 class="dashboard-widget__text">@lang('KYC Documents Rejected')</h6>
                <p class="dashboard-widget__number">
                    {{ __(@$kyc->data_values->reject) }}
                    <a href="{{ route('user.kyc.form') }}" class="text--base">@lang('Click Here to Re-submit Documents')</a>.
                    <br>

                    <a href="{{ route('user.kyc.data') }}" class="text--base">@lang('View KYC Data')</a> /
                    <a href="javascript:void(0)" data-bs-toggle="modal" data-bs-target="#kycRejectionReason"
                        class="text--base">
                        @lang('Show Rejection Reason')
                    </a>
                </p>
            </div>
        </div>
    @elseif(auth()->user()->kv == Status::KYC_UNVERIFIED)
        <div class="dashboard-widget flex-align alert-info mb-3">
            <span class="dashboard-widget__icon flex-center"><i class="las la-user-check"></i></span>
            <div class="dashboard-widget__content">
                <h6 class="dashboard-widget__text">@lang('KYC Verification Required')</h6>
                <p class="dashboard-widget__number">
                    {{ __(@$kyc->data_values->required) }}
                    <a href="{{ route('user.kyc.form') }}" class="text--base">@lang('Click Here to Submit Documents')</a>
                </p>
            </div>
        </div>
    @elseif(auth()->user()->kv == Status::KYC_PENDING)
        <div class="dashboard-widget flex-align alert-warning mb-3">
            <span class="dashboard-widget__icon flex-center"><i class="las la-user-clock"></i></span>
            <div class="dashboard-widget__content">
                <h6 class="dashboard-widget__text">@lang('KYC Verification Pending')</h6>
                <p class="dashboard-widget__number">
                    {{ __(@$kyc->data_values->pending) }}
                    <a href="{{ route('user.kyc.data') }}" class="text--base">@lang('See KYC Data')</a>
                </p>
            </div>
        </div>
    @endif


    <div class="row gy-3 justify-content-center dashboard-widget-wrapper">
        <div class="col-xl-4 col-md-4 col-sm-6 col-xsm-6">
            <a href="{{ route('user.transactions') }}" class="dashboard-widget flex-align">
                <span class="dashboard-widget__icon flex-center"><i class="lar la-credit-card"></i></span>
                <div class="dashboard-widget__content">
                    <span class="dashboard-widget__text">@lang('Balance')</span>
                    <h4 class="dashboard-widget__number">{{ showAmount($widget['balance']) }}
                    </h4>
                </div>
            </a>
        </div>
        <div class="col-xl-4 col-md-4 col-sm-6 col-xsm-6">
            <a href="{{ route('user.order.index') }}" class="dashboard-widget flex-align">
                <span class="dashboard-widget__icon flex-center"><i class="las la-file-alt"></i></span>
                <div class="dashboard-widget__content">
                    <span class="dashboard-widget__text">@lang('Orders')</span>
                    <h4 class="dashboard-widget__number">{{ $widget['total_orders'] }}</h4>
                </div>
            </a>
        </div>
        <div class="col-xl-4 col-md-4 col-sm-6 col-xsm-6">
            <a href="{{ route('user.order.active') }}" class="dashboard-widget flex-align">
                <span class="dashboard-widget__icon flex-center"><i class="las la-calendar-check"></i></span>
                <div class="dashboard-widget__content">
                    <span class="dashboard-widget__text">@lang('Active Orders')</span>
                    <h4 class="dashboard-widget__number">{{ $widget['active_orders'] }}</h4>
                </div>
            </a>
        </div>

        <div class="col-xl-4 col-md-4 col-sm-6 col-xsm-6">
            <a href="{{ route('user.order.payment.pending') }}" class="dashboard-widget flex-align">
                <span class="dashboard-widget__icon flex-center"><i class="las la-spinner"></i></span>
                <div class="dashboard-widget__content">
                    <span class="dashboard-widget__text">@lang('Payment Pending')</span>
                    <h4 class="dashboard-widget__number">{{ $widget['payment_pending_orders'] }}</h4>
                </div>
            </a>
        </div>
        <div class="col-xl-4 col-md-4 col-sm-6 col-xsm-6">
            <a href="{{ route('user.favorite.foods') }}" class="dashboard-widget flex-align">
                <span class="dashboard-widget__icon flex-center"><i class="las la-hamburger"></i></span>
                <div class="dashboard-widget__content">
                    <span class="dashboard-widget__text">@lang('Favorite Foods')</span>
                    <h4 class="dashboard-widget__number">{{ $widget['favorite_foods'] }}</h4>
                </div>
            </a>
        </div>
        <div class="col-xl-4 col-md-4 col-sm-6 col-xsm-6">
            <a href="{{ route('favorite.restaurants') }}" class="dashboard-widget flex-align">
                <span class="dashboard-widget__icon flex-center"><i class="las la-heartbeat"></i></span>
                <div class="dashboard-widget__content">
                    <span class="dashboard-widget__text">@lang('Favorite Restaurants')</span>
                    <h4 class="dashboard-widget__number">{{ $widget['favorite_restaurants'] }}</h4>
                </div>
            </a>
        </div>
    </div>

    <div class="row g-3 justify-content-center mt-4">
        <div class="col-12">
            <div class="dashboard-table">
                <div class="dashbaord-table-header">
                    <h6 class="card-header__title mb-0">@lang('Orders')</h6>
                </div>
                <table class="table table--responsive--xl">
                    <thead>
                        <tr>
                            <th>@lang('Restaurant name')</th>
                            <th class="text-center">@lang('Price')</th>
                            <th class="text-center">@lang('Payment')</th>
                            <th class="text-center">@lang('Payment Type')</th>
                            <th class="text-center">@lang('Status')</th>
                            <th>@lang('Action')</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($latestOrders as $order)
                            <tr>
                                <td lass="text-left">
                                    <span class="fw-bold">
                                        <a href="{{ route('restaurant.details', @$order->restaurant->slug) }}"
                                            class="text--base">
                                            {{ __(@$order->restaurant->restaurant_name) }}
                                        </a>
                                    </span>
                                </td>
                                <td class="text-center">
                                    {{ showAmount($order->total_price) }}
                                </td>
                                <td class="text-center">
                                    @php echo $order->paymentData @endphp
                                </td>

                                <td>
                                    @php echo $order->typeBadge @endphp
                                </td>
    
                                <td class="text-center">
                                    @php echo $order->statusBadge @endphp
                                </td>
                                <td>
                                    <a class="btn btn--sm btn--base detailBtn"
                                        href="{{ route('user.order.details', $order->id) }}">
                                        <i class="la la-desktop"></i>
                                    </a>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td class="text-muted text-center" colspan="100%">{{ __($emptyMessage) }}</td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>
    </div>
@endsection


@if (auth()->user()->kv == Status::KYC_UNVERIFIED && auth()->user()->kyc_rejection_reason)
    <div class="modal fade" id="kycRejectionReason">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">@lang('KYC Document Rejection Reason')</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <p>{{ auth()->user()->kyc_rejection_reason }}</p>
                </div>
            </div>
        </div>
    </div>
@endif
