@php
    $topRatedRestaurant = getContent('top_rated_restaurant.content', true);
    $restaurants = App\Models\Restaurant::active()
        ->whereHas('foods')
        ->with('location', 'reviews')
        ->whereHas('reviews')
        ->withCount('reviews')
        ->withAvg('reviews', 'rating')
        ->orderByDesc('reviews_avg_rating')
        ->get();
    $showAllBtn = $restaurants->count() > 8;
    $restaurants = $restaurants->take(8);
@endphp

<section class="nearby-restaurant-area section-bg-two pt-40 pb-40">
    <img class="nearby-shap" src="{{ getImage($activeTemplateTrue . 'images/nearby-shape.png') }}" alt="img not found" />
    <img class="nearby-shap-dark" src="{{ getImage($activeTemplateTrue . 'images/nearby-shape-dark.png') }}"
        alt="img not found" />
    <div class="container">
        <div class="row">
            <div class="col-xl-12">
                <div class="section-common pb-20 d-flex align-items-center justify-content-between">
                    <h4 class="section-title">{{ __(@$topRatedRestaurant->data_values->heading) }}</h4>
                    @if ($showAllBtn)
                        <a href="{{ route('top.rated.restaurants') }}" class="btn btn--base btn--sm"> @lang('View All') <span
                                class="section-icon"><i class="la la-arrow-right"></i></span> </a>
                    @endif
                </div>
            </div>
        </div>
        <div class="nearby-restaurant">
            <img class="nearby-shap2" src="{{ getImage($activeTemplateTrue . 'images/nearby-shape-2.png') }}"
                alt="img not found" />
            <img class="nearby-shap3" src="{{ getImage($activeTemplateTrue . 'images/nearby-shape-3.png') }}"
                alt="img not found" />
            <img class="nearby-shap2-dark" src="{{ getImage($activeTemplateTrue . 'images/nearby-shape-2-dark.png') }}"
                alt="img not found" />
            <img class="nearby-shap3-dark" src="{{ getImage($activeTemplateTrue . 'images/nearby-shape-3-dark.png') }}"
                alt="img not found" />

            <div class="row gy-4">
                @foreach ($restaurants as $restaurant)
                    <div class="col-xl-3 col-lg-4 col-md-6 col-sm-6 col--xm-6">
                        <x-restaurant :restaurant="$restaurant" />
                    </div>
                @endforeach
            </div>
        </div>
    </div>
</section>
