@php
    $howItWorkContent = getContent('how_it_work.content', true);
    $howItWorkElements = getContent('how_it_work.element', orderById: true);
@endphp

<section class="how-it-work section-bg-two pt-120  pb-80">
    <div class="container">
        <div class="row gy-4 justify-content-center">
            <div class="col-xl-12">
                <div class="section-common text-center">
                    <h2 class="section-common-title">
                        {{ __(@$howItWorkContent->data_values->title) }}
                    </h2>
                </div>
            </div>
            <div class="col-lg-10">
                <div class="how-to-deal-wrapper">
                    @foreach ($howItWorkElements as $howItWorkElement)
                        <div class="how-to-deal flex-between">
                            <div class="how-to-deal__thumb">
                                <div class="how-to-deal__img flex-center">
                                    <img src="{{ frontendImage('how_it_work', @$howItWorkElement->data_values->image, '170x140') }}"
                                        alt="img not found">
                                </div>
                            </div>
                            <div class="how-to-deal__content">
                                <h4 class="how-to-deal__title">{{ __(@$howItWorkElement->data_values->title) }}</h4>
                                <p class="how-to-deal__desc">{{ __(@$howItWorkElement->data_values->description) }}</p>
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>
        </div>
    </div>
</section>
