@php
    $categories = App\Models\Category::active()
        ->featured()
        ->whereHas('foods', function ($query) {
            $query->whereHas('restaurant', function ($query) {
                $query->active();
            });
        })
        ->with('foods', 'foods.restaurant')
        ->orderBy('sort_order')
        ->get();
@endphp

@foreach ($categories as $category)
    <div class="popular-foods-area section-bg-two pt-40 pb-40">
        <div class="container">
            <div class="row">
                <div class="col-xl-12">
                    <div class="section-common pb-20 d-flex align-items-center justify-content-between">
                        <h4 class="section-title">{{ __($category->name) }}</h4>
                        <a href="{{ route('category.foods', $category->slug) }}" class="btn btn--base btn--sm"> @lang('View All')
                            <span class="section-icon"><i class="la la-arrow-right"></i></span> </a>
                    </div>
                </div>
            </div>
            <div class="popular-foods-wrapper">
                <div class="row gy-4">
                    @foreach ($category->foods->take(6) as $food)
                        <div class="col-lg-4 col-md-6 col-sm-6 col--xm-6">
                            <x-food :food="$food" :isSection="true" />
                        </div>
                    @endforeach
                </div>
            </div>
        </div>
    </div>
@endforeach
