@php
    $advertisements = getContent('advertisement.element', orderById: true);
@endphp


<div class="discount-ads section-bg-two pt-40 pb-60">
    <div class="container">
        <div class="row">
            <div class="col-xl-12">
                <div class="discount-ads__slider">
                    @foreach ($advertisements as $advertisement)
                        <div class="discount-ads-item">
                            <a href="{{ __(@$advertisement->data_values->link) }}"><img class="w-100"
                                    src="{{ frontendImage('advertisement', @$advertisement->data_values->image, '625x240') }}"
                                    alt="img not found"></a>
                        </div>
                    @endforeach
                </div>
            </div>
        </div>
    </div>
</div>


@if (!app()->offsetExists('slick_script'))
    @push('style-lib')
        <link rel="stylesheet" href="{{ asset($activeTemplateTrue . 'css/slick.css') }}">
    @endpush

    @push('script-lib')
        <script src="{{ asset($activeTemplateTrue . 'js/slick.min.js') }}"></script>
    @endpush

    @php app()->offsetSet('slick_script',true) @endphp
@endif

@push('script')
    <script>
        (function($) {
            "use strict";

            $(".discount-ads__slider").slick({
                fade: false,
                slidesToShow: 2,
                slidesToScroll: 1,
                infinite: true,
                autoplay: true,
                pauseOnHover: true,
                centerMode: false,
                dots: true,
                arrows: false,
                nextArrow: '<i class="las la-arrow-right arrow-right"></i>',
                prevArrow: '<i class="las la-arrow-left arrow-left"></i> ',
                responsive: [

                    {
                        breakpoint: 767,
                        settings: {
                            slidesToShow: 1,
                        },
                    },
                    {
                        breakpoint: 575,
                        settings: {
                            slidesToShow: 1,
                        },
                    },
                ],
            });
        })(jQuery);
    </script>
@endpush
