@extends($activeTemplate . 'layouts.frontend')
@section('content')
    @php
        $advertisement_one = showAd('1296x190');
        $advertisement_two = showAd('1296x190');
    @endphp
    <section class="common-body section-bg-two pt-80 pb-80">
        <div class="container">
            @if ($advertisement_one)
                <a class="ad-thumb"
                    @if ($advertisement_one['route']) href="{{ $advertisement_one['route'] }}" target="_blank" @endif>
                    <img src="{{ $advertisement_one['image'] }}" alt="ad-thumb">
                </a>
            @endif
            <div class="nearby-restaurant">
                <div class="row gy-4">
                    @foreach ($restaurants as $restaurant)
                        <div class="col-xl-3 col-lg-4 col-md-6 col-sm-6 col--xm-6">
                            <x-restaurant :restaurant="$restaurant" />
                        </div>
                    @endforeach
                </div>
            </div>
            @if ($advertisement_two)
                <a class="ad-thumb mt-5"
                    @if ($advertisement_two['route']) href="{{ $advertisement_two['route'] }}"  target="_blank" @endif>
                    <img src="{{ $advertisement_two['image'] }}" alt="ad-thumb">
                </a>
            @endif
            <div class="pagination-area mt-4">
                {{ paginateLinks($restaurants) }}
            </div>
        </div>
    </section>
@endsection
