@extends($activeTemplate . 'layouts.frontend')
@section('content')
    <div class="container py-70">
        <div class="row justify-content-center">
            <div class="col-md-10">
                <div class="card custom--card">
                    <div class="card-body">
                        <form method="POST" action="{{ route('restaurant.data.submit') }}" enctype="multipart/form-data">
                            @csrf

                            <!-- Restaurant Details -->
                            <h5 class="mt-4 mb-4">@lang('Restaurant Details') <i class="las la-utensils text--base"></i></h5>
                            <div class="row">
                                <div class="form-group col-sm-6">
                                    <label class="form-label">@lang('Restaurant Name')</label>
                                    <input type="text" class="form-control form--control" name="restaurant_name"
                                        value="{{ old('restaurant_name') }}" required>
                                </div>
                                <div class="form-group col-sm-6">
                                    <label class="form-label">@lang('Username')</label>
                                    <input type="text" class="form-control form--control checkUser" name="username"
                                        value="{{ old('username') }}">
                                    <small class="text--danger usernameExist"></small>
                                    <small class="form-text text-muted">@lang('Username will be used for login and identification')</small>
                                </div>
                            </div>

                            <div class="row mt-3">
                                <div class="form-group col-sm-12">
                                    <label class="form-label">@lang('Address')</label>
                                    <input type="text" class="form-control form--control" name="address"
                                        value="{{ old('address') }}">
                                </div>
                                <div class="form-group col-sm-4">
                                    <label class="form-label">@lang('State')</label>
                                    <input type="text" class="form-control form--control" name="state"
                                        value="{{ old('state') }}">
                                </div>
                                <div class="form-group col-sm-4">
                                    <label class="form-label">@lang('Zip Code')</label>
                                    <input type="text" class="form-control form--control" name="zip"
                                        value="{{ old('zip') }}">
                                </div>
                                <div class="form-group col-sm-4">
                                    <label class="form-label">@lang('City')</label>
                                    <input type="text" class="form-control form--control" name="city"
                                        value="{{ old('city') }}">
                                </div>
                            </div>

                            <!-- Service Information -->
                            <h5 class="mt-4 mb-4">@lang('Service Information') <i class="las la-truck text--base"></i></h5>
                            <div class="row">
                                <div class="form-group col-sm-6">
                                    <label class="form-label">@lang('Delivery Time')</label>
                                    <div class="input-group">
                                        <input type="number" class="form-control form--control" name="delivery_time"
                                            value="{{ old('delivery_time') }}" required>
                                        <div class="input-group-text">@lang('Minutes')</div>
                                    </div>
                                </div>
                                <div class="form-group col-sm-6">
                                    <label class="form-label">@lang('Delivery Charge')</label>
                                    <div class="input-group">
                                        <input type="number" class="form-control form--control" name="delivery_charge"
                                            value="{{ old('delivery_charge') }}" required>
                                        <div class="input-group-text">{{ gs('cur_sym') }}</div>
                                    </div>
                                </div>
                            </div>

                            <!-- Media -->
                            <h5 class="mt-4 mb-4">@lang('Media') <i class="las la-camera text--base"></i></h5>
                            <div class="row">
                                <div class="form-group col-12">
                                    <label>
                                        @lang('Cover Image')
                                        <i class="las la-info-circle" data-toggle="tooltip" title="@lang('Upload a cover image for your restaurant. This image will be displayed at the top of your restaurant details page.')"></i>
                                    </label>
                                    <x-image-uploader class="w-100" type="restaurantCover" :required=false
                                        id="restaurantCover" name="cover_image" />
                                </div>
                                <div class="form-group col-sm-6">
                                    <label>
                                        @lang('Thumbnail Image')
                                        <i class="las la-info-circle" data-toggle="tooltip" title="@lang('Upload a thumbnail image that represents your restaurant in listings and previews.')"></i>
                                    </label>
                                    <x-image-uploader class="w-100" type="restaurantCoverThumb" :required=false
                                        id="restaurantCoverThumb" name="cover_image_thumb" />
                                </div>
                                <div class="form-group col-sm-6">
                                    <label>
                                        @lang('Profile Image')
                                        <i class="las la-info-circle" data-toggle="tooltip" title="@lang('Upload a profile image for your restaurant, typically a restaurant logo.')"></i>
                                    </label>
                                    <x-image-uploader class="w-100" type="restaurantProfile" :required=false
                                        id="restaurantProfile" name="profile_image" />
                                </div>


                                <!-- Submit Button -->
                                <div class="form-group mb-0">
                                    <button type="submit" class="btn btn--base w-100">
                                        @lang('Submit')
                                    </button>
                                </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('style')
    <style>
        .footer-area {
            display: none
        }
    </style>
@endpush

@push('script')
    <script>
        "use strict";
        (function($) {
            $('.checkUser').on('focusout', function(e) {
                var value = $(this).val();
                var name = $(this).attr('name');
                checkUser(value, name);
            });

            function checkUser(value, name) {
                var url = '{{ route('restaurant.checkUser') }}';
                var token = '{{ csrf_token() }}';

                if (name == 'username') {
                    var data = {
                        username: value,
                        _token: token
                    };
                }

                $.post(url, data, function(response) {
                    if (response.data != false) {
                        $(`.${response.type}Exist`).text(`${response.field} already exist`);
                    } else {
                        $(`.${response.type}Exist`).text('');
                    }
                });
            }
        })(jQuery);
    </script>
@endpush
