<div class="food-sticky-header">
    <div class="step-header">
        <div class="stepform">
            <ul class="nav progressbar nav-pills project-setup-menu">
                <li class="nav-item {{ menuActive('restaurant.food.overview', 5) }}  active" role="presentation">
                    <a class="nav-btn" href="{{ route('restaurant.food.overview', @$food->id) }}">
                        @lang('Overview')
                    </a>
                </li>
                <li
                    class="nav-item {{ menuActive('restaurant.food.image', 5) }} @if (@$food->step >= Status::FOOD_OVERVIEW) active @endif">
                    <a class="nav-btn"
                        href="@if ($food && @$food->step >= Status::FOOD_OVERVIEW) {{ route('restaurant.food.image', $food->id) }}@else # @endif">
                        @lang('Image')
                    </a>
                </li>
                <li
                    class="nav-item {{ menuActive('restaurant.food.variation', 5) }} @if (@$food->step >= Status::FOOD_IMAGE) active @endif">
                    <a class="nav-btn"
                        href="@if ($food && @$food->step > Status::FOOD_OVERVIEW) {{ route('restaurant.food.variation', $food->id) }}@else # @endif">
                        @lang('Variations')</a>
                </li>
                <li
                    class="nav-item {{ menuActive('restaurant.food.addons', 5) }} @if (@$food->step >= Status::FOOD_VARIATIONS) active @endif">
                    <a class="nav-btn"
                        href="@if ($food && @$food->step > Status::FOOD_IMAGE) {{ route('restaurant.food.addons', $food->id) }}@else # @endif">
                        @lang('Addons')
                    </a>
                </li>
                <li
                    class="nav-item {{ menuActive('restaurant.food.publish', 5) }} @if (@$food->step >= Status::FOOD_ADDONS) active @endif">
                    <a class="nav-btn"
                        href="@if ($food && @$food->step > Status::FOOD_VARIATIONS) {{ route('restaurant.food.publish', $food->id) }}@else # @endif">
                        @lang('Publish')
                    </a>
                </li>
            </ul>
        </div>
    </div>
</div>
@push('style')
    <style>
        .spinner-border {
            width: 1rem;
            height: 1rem;
        }
    </style>
@endpush

@push('script')
    <script>
        (function($) {
            "use strict";

            $(document).ready(function() {
                $('.progressbar .nav-item').click(function(event) {
                    event.preventDefault();

                    var url = $(this).find('.nav-btn').attr('href');
                    if (url != '#') {
                        window.location.href = url;
                    }
                });
            });

        })(jQuery);
    </script>
@endpush
