@extends($activeTemplate . 'restaurant.layouts.master')
@section('content')
    <div class="py-70">
        <div class="container">
            <div class="row justify-content-center mt-2">
                <div class="col-lg-12 ">
                    <div class="dashboard-table">
                        <div class="dashbaord-table-header">
                            <h6 class="card-header__title mb-0">{{ $pageTitle }} <i
                                    class="las la-hamburger text--base"></i></h6>
                            <form class="search-form active">
                                <input type="text" name="search" class="form--control" value="{{ request()->search }}"
                                    placeholder="@lang('Search here')...">
                                <button type="submit" class="search-form__btn"><i class="las la-search"></i></button>
                            </form>
                        </div>


                        <table class="table table--responsive--lg">
                            <thead>
                                <tr>
                                    <th>@lang('User')</th>
                                    <th>@lang('Address')</th>
                                    <th>@lang('Total Price')</th>
                                    <th>@lang('Payment Type')</th>
                                    <th>@lang('Status')</th>
                                    <th>@lang('Action')</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($orders as $order)
                                    <tr>
                                        <td>
                                            <div>
                                                {{ __($order->user->fullname) }} <br />
                                                <small><a
                                                        href="{{ route('restaurant.order.index', ['search' => $order->user->username]) }}">{{ __($order->user->username) }}</a></small>
                                            </div>
                                        </td>
                                        <td>
                                            {{ __(strLimit($order->address, 40)) }}
                                        </td>

                                        <td>
                                            <div>
                                                {{ showAmount($order->total_price) }} <br>
                                                <small
                                                    class="text--base">{{ showDateTime($order->created_at, 'd/m/y @ h A') }}</small>
                                            </div>
                                        </td>

                                        <td>
                                            @php echo $order->typeBadge @endphp
                                        </td>

                                        <td>
                                            @php echo $order->statusBadge @endphp
                                            @if ($order->status == Status::ORDER_DELIVERED)
                                                <span class="infoIcon" data-toggle="tooltip" data-placement="top"
                                                    title="@lang('Payment will get dispersed once user confirms the order')">
                                                    <i class="fas fa-info-circle"></i>
                                                </span>
                                            @endif
                                        </td>

                                        <td>
                                            <a href="{{ route('restaurant.order.details', $order->id) }}"
                                                class="btn btn--sm btn--base btn-outline--base btn--sm">
                                                <i class="la la-eye"></i>
                                            </a>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td class="text-muted empty-message" colspan="100%">{{ __($emptyMessage) }}</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                    <div class="mt-3">
                        @if ($orders->hasPages())
                            {{ paginateLinks($orders) }}
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
