@extends($activeTemplate . 'restaurant.layouts.master')
@section('content')
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-9"> @include($activeTemplate . 'restaurant.partials.food_progress_bar') </div>
        </div>
        <form id="foodForm">
            <div class="card custom--card mt-5 mb-3 variant">
                <div class="card-body">
                    <div class="row justify-content-center">
                        <div class="col-lg-9">
                            <div class="food-publish text-center">
                                <div class="food-publish-icon text--base">
                                    <i class="far fa-check-circle"></i>
                                </div>
                                @if ($food->status == Status::FOOD_PUBLISHED)
                                    <h5 class="mb-0 draft-notify">@lang('Congratulations! Food is published.')</h5>
                                @else
                                    <h5 class="mb-3 published-notify"> @lang('Almost Ready for Publishing')</h5>
                                    <p class="mb-3 info">@lang('Your anticipation is appreciated as we put the finishing touches on the food item. Are you ready to publish?')</p>
                                    <button class="btn btn--base" id="foodPublished"
                                        type="button">@lang('Publish Your Food Now')</button>
                                @endif
                            </div>
                        </div>
                    </div>
                </div>
            </div>

        </form>
    </div>
@endsection

@push('style')
    <style>
        button.btn.btn--danger.deleteVariantItem {
            margin-top: 32px;
        }

        @media only screen and (max-width: 768px) {
            button.btn.btn--danger.deleteVariantItem {
                padding: 14px 6px;
            }
        }

        .deleteVariant {
            position: absolute;
            top: 0px;
            right: 0;
            padding: 2px;
            border-radius: 50%;
        }
    </style>
@endpush

@push('script')
    <script>
        (function($) {
            "use strict";

            $('#saveAndDraft').on('click', function() {
                foodFinalAction(0, $(this));
            });

            $('#foodPublished').on('click', function() {
                foodFinalAction(1, $(this));
            });

            function foodFinalAction(isPublished, btn) {
                var btnText = btn.text();
                var spinnerHtml = '<div class="spinner-border"></div>';
                var url = '{{ route('restaurant.food.store.publish', $food->id) }}';
                var token = '{{ csrf_token() }}';

                btn.attr('disabled', true);

                var data = {
                    is_published: isPublished,
                    _token: token
                };

                $.ajax({
                    url: url,
                    method: 'POST',
                    data: data,
                    beforeSend: function() {
                        btn.html(spinnerHtml + ' ' + (isPublished ? '@lang('Publishing')' :
                            '@lang('Drafting')') + '...');
                        btn.attr('disabled', true);
                    },
                    complete: function(e) {
                        btn.html(btnText);
                        btn.removeAttr('disabled');
                    },
                    success: function(response) {
                        if (response.success) {
                            if (response.status == 0) {
                                notify('success', `@lang('Food save and drafted successfully')`);
                                $('.draft-notify').text(`@lang('Food is Drafted')`);
                            } else {
                                $('.published-notify').text(`@lang('Congratulations!')`);
                            }
                            setTimeout(() => {
                                btn.hide();
                                $('.info').hide();
                                window.location.href = response.redirect_url;
                            }, 1000);
                        } else {
                            notify('error', response.message);
                        }
                    },
                    error: function(xhr, status, error) {
                        notify('error', error);
                        btn.html(btnText);
                        btn.removeAttr('disabled');
                    }
                });

            }


        })(jQuery);
    </script>
@endpush
