@extends($activeTemplate . 'restaurant.layouts.master')
@section('content')
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-9">
                @include($activeTemplate . 'restaurant.partials.food_progress_bar')
            </div>
        </div>
        <div class="card custom--card mt-5 mb-3">
            <div class="card-body">
                <form id="foodForm">
                    <div class="form-group">
                        <label class="form-label required">@lang('Name')</label>
                        <input type="text" class="form-control form--control" name="name"
                            value="{{ old('name', @$food->name) }}" required>
                    </div>
                    <div class="form-group">
                        <label class="form-label required">@lang('Short Description')</label>
                        <input type="text" class="form-control form--control" name="short_description"
                            value="{{ old('short_description', @$food->short_description) }}" required>
                    </div>

                    <div class="form-group select2-parent position-relative">
                        <label>@lang('Categories')</label>
                        <small class="ms-2 mt-2  ">@lang('Separate multiple keywords by') <code>,</code>(@lang('comma')) @lang('or')
                            <code>@lang('enter')</code> @lang('key')</small>
                        <select name="categories[]" class="form-control select2-auto-tokenize" multiple="multiple" required>
                            @if (@$categories)
                                @foreach ($categories as $category)
                                    <option value="{{ $category->id }}"
                                        @if ($food) {{ $food->categories->contains('id', $category->id) ? 'selected' : '' }} @endif>
                                        {{ __($category->name) }}</option>
                                @endforeach
                            @endif
                        </select>
                    </div>


                    <div class="form-group">
                        <label class="form-label required">@lang('Price')</label>
                        <div class="input-group">
                            <input type="number" class="form-control form--control" name="price"
                                value="{{ old('price', showAmount(@$food->price, currencyFormat: false)) }}" required>
                            <div class="input-group-text">{{ gs('cur_sym') }}</div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
        <div class="d-flex justify-content-end">
            @if (!request()->routeIs('restaurant.food.publish'))
                <button class="btn btn--base" id="saveAndContinue" type="button">
                    @lang('Save & Continue') <i class="las la-angle-right"></i>
                </button>
            @endif
        </div>

    </div>
@endsection

@push('style-lib')
    <link rel="stylesheet" href="{{ asset('assets/restaurant/css/select2.min.css') }}">
@endpush

@push('script-lib')
    <script src="{{ asset('assets/restaurant/js/select2.min.js') }}"></script>
@endpush



@push('script')
    <script>
        (function($) {
            "use strict";

            $('.select2-auto-tokenize').select2({
                dropdownParent: $('.select2-parent'),
                tags: false,
                tokenSeparators: [',']
            });

            //Ajax
            $('#saveAndContinue').on('click', function() {
                var btn = $(this);
                var btnName = `@lang('Save & Continue') <i class="las la-angle-right"></i>`;

                //store
                var formData = new FormData($('#foodForm')[0]);
                var url = '{{ route('restaurant.food.store.overview', @$food->id ?? '') }}';
                var token = '{{ csrf_token() }}';
                formData.append('_token', token);


                $.ajax({
                    url: url,
                    method: 'POST',
                    data: formData,
                    processData: false,
                    contentType: false,
                    beforeSend: function() {
                        var btnAfterSubmit =
                            `<div class="spinner-border"></div> @lang('Saving')...`;
                        btn.html(btnAfterSubmit);
                        btn.attr('disabled', true);
                    },
                    complete: function(e) {
                        btn.html(btnName);
                        btn.removeAttr('disabled');
                    },
                    success: function(response) {
                        if (response.success) {
                            @if (!$food)
                                window.location.href = response.redirect_url
                            @else
                                notify('success', `@lang('Food overview updated successfully')`);
                                btn.html(btnName);
                                btn.removeAttr('disabled');
                            @endif
                        } else {
                            notify('error', response.message);
                            btn.html(btnName);
                            btn.removeAttr('disabled');
                        }
                    },
                    error: function(xhr, status, error) {
                        notify('error', error);
                        btn.html(btnName);
                        btn.removeAttr('disabled');
                    }
                });

            });

        })(jQuery);
    </script>
@endpush
