@extends($activeTemplate . 'restaurant.layouts.master')
@section('content')
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-9"> @include($activeTemplate . 'restaurant.partials.food_progress_bar') </div>
        </div>
        <form id="foodForm">
            <div class="card custom--card mt-5 mb-3">
                <div class="card-body">
                    @forelse ($food->addons as $addon)
                        <div class="row addon-item">
                            <div class="col flex-input">
                                <div class="form-group">
                                    <label class="form-label required">@lang('Name')</label>
                                    <input type="text" name="addons[{{ $addon->id }}][name]"
                                        class="form-control form--control" value="{{ $addon->name }}" required>
                                </div>
                            </div>
                            <div class="col flex-input">
                                <div class="form-group">
                                    <label class="form-label required">@lang('Price')</label>
                                    <div class="input-group">
                                        <input type="number" class="form-control form--control"
                                            name="addons[{{ $addon->id }}][price]"
                                            value="{{ showAmount($addon->price, currencyFormat: false) }}" required>
                                        <div class="input-group-text">{{ gs('cur_sym') }}</div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-auto">
                                <button class="btn btn--danger deleteAddonItem">
                                    <i class="las la-times" aria-hidden="true"></i>
                                </button>
                            </div>
                        </div>
                    @empty
                        <p class="card-text text-center empty-message">{{ $emptyMessage }}</p>
                    @endforelse
                </div>
            </div>
        </form>
        <div class="d-flex justify-content-between">
            <button class="btn btn--base addAddons" type="button"> @lang('Add Addons') <i class="las la-plus"></i>
            </button>

            <button class="btn btn--base" id="saveAndContinue" type="button"> @lang('Save & Continue') <i
                    class="las la-angle-right"></i>
            </button>
        </div>
    </div>
@endsection

@push('style')
    <style>
        button.btn.btn--danger.deleteAddonItem {
            margin-top: 32px;
        }

        @media only screen and (max-width: 768px) {
            button.btn.btn--danger.deleteAddonItem {
                padding: 14px 6px;
            }
        }
    </style>
@endpush

@push('script')
    <script>
        (function($) {
            "use strict";

            function generateRandomNumber() {
                return Math.floor(Math.random() * (999999 - 100000 + 1)) + 100000;
            }

            function displayEmptyMessage() {
                if ($('.addon-item').length > 0) {
                    $('.empty-message').addClass('d-none');
                } else {
                    $('.empty-message').removeClass('d-none');
                }
            }

            function setAddonItemListners() {
                $('.deleteAddonItem').on('click', function(event) {
                    event.preventDefault(); // Prevent default form submission
                    var addonItem = $(this).closest('.addon-item');
                    addonItem.remove(); // Remove the closest addonItem item when delete button clicked
                    displayEmptyMessage();
                });
            }

            function setAddonListeners() {
                $('.addAddons').on('click', function(event) {
                    event.preventDefault(); // Prevent default form submission
                    var addonId = generateRandomNumber();
                    var addonItemHTML = `
                        <div class="row addon-item">
                            <div class="col flex-input">
                                <div class="form-group">
                                    <label class="form-label required">@lang('Name')</label>
                                    <input type="text" name="addons[${addonId}][name]" class="form-control form--control" required>
                                </div>
                            </div>

                            <div class="col flex-input">
                                <div class="form-group">
                                    <label class="form-label required">@lang('Price')</label>
                                    <div class="input-group">
                                        <input type="number" class="form-control form--control" name="addons[${addonId}][price]" required>
                                        <div class="input-group-text">{{ gs('cur_sym') }}</div>
                                    </div>
                                </div>
                            </div>

                            <div class="col-auto">
                                <button class="btn btn--danger deleteAddonItem">
                                    <i class="las la-times" aria-hidden="true"></i>
                                </button>
                            </div>
                        </div>
                    `

                    $('.card-body').append(addonItemHTML);
                    setAddonItemListners()
                    displayEmptyMessage();
                });
            }

            $(document).ready(function() {
                setAddonListeners()
                setAddonItemListners()
            });

            //Ajax
            $('#saveAndContinue').on('click', function() {
                var btn = $(this);
                var btnName = `@lang('Save & Continue') <i class="las la-angle-right"></i>`;

                //store
                var formData = new FormData($('#foodForm')[0]);
                var url = '{{ route('restaurant.food.store.addons', @$food->id ?? '') }}';
                var token = '{{ csrf_token() }}';
                formData.append('_token', token);


                $.ajax({
                    url: url,
                    method: 'POST',
                    data: formData,
                    processData: false,
                    contentType: false,
                    beforeSend: function() {
                        var btnAfterSubmit =
                            `<div class="spinner-border"></div> @lang('Saving')...`;
                        btn.html(btnAfterSubmit);
                        btn.attr('disabled', true);
                    },
                    complete: function(e) {
                        btn.html(btnName);
                        btn.removeAttr('disabled');
                    },
                    success: function(response) {
                        if (response.success) {
                            if (!response.is_update) {
                                window.location.href = response.redirect_url
                            } else {
                                notify('success', `@lang('Addons updated successfully')`);
                                btn.html(btnName);
                                btn.removeAttr('disabled');
                            }
                        } else {
                            notify('error', response.message);
                            btn.html(btnName);
                            btn.removeAttr('disabled');
                        }
                    },
                    error: function(xhr, status, error) {
                        notify('error', error);
                        btn.html(btnName);
                        btn.removeAttr('disabled');
                    }
                });

            });
        })(jQuery);
    </script>
@endpush
