@extends($activeTemplate . 'restaurant.layouts.master')
@section('content')
    <div class="py-70">
        <div class="container">
            <div class="row justify-content-center mt-2">
                <div class="col-lg-12 ">
                    <div class="card custom--card">
                        <div class="card-body">
                            <form class="register" action="{{ route('restaurant.delivery.setting.store') }}" method="post"
                                enctype="multipart/form-data">
                                @csrf
                                <div class="row">
                                    <div class="form-group col-sm-12">
                                        <label class="form-label">@lang('Delivery Time')</label>
                                        <div class="input-group">
                                            <input type="number" class="form-control form--control" name="delivery_time"
                                                value="{{ $restaurant->delivery_time ? $restaurant->delivery_time : old('delivery_time') }}"
                                                required>
                                            <div class="input-group-text">@lang('Minutes')</div>
                                        </div>
                                    </div>

                                    <div class="form-group col-sm-12">
                                        <label class="form-label">@lang('Delivery Charge')</label>
                                        <div class="input-group">
                                            <input type="number" class="form-control form--control" name="delivery_charge"
                                                value="{{ $restaurant->delivery_charge ? showAmount($restaurant->delivery_charge, currencyFormat: false) : old('delivery_charge') }}"
                                                required>
                                            <div class="input-group-text">{{ gs('cur_sym') }}</div>
                                        </div>
                                    </div>

                                    <div class="form-group col-sm-12">
                                        <label class="form-label">@lang('Vat')</label>
                                        <div class="input-group">
                                            <input type="number" class="form-control form--control" name="vat"
                                                value="{{ $restaurant->vat ? showAmount($restaurant->vat, currencyFormat: false) : old('vat') }}"
                                                required>
                                            <div class="input-group-text">%</div>
                                        </div>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <button type="submit" class="btn btn--base w-100">@lang('Submit')</button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
