@extends($activeTemplate . 'restaurant.layouts.master')
@section('content')
    <div class="py-70">
        <div class="container">
            <div class="row justify-content-center mt-2">
                <div class="col-lg-12 ">
                    <div class="dashboard-table">
                        <div class="dashbaord-table-header">
                            <h6 class="card-header__title mb-0">@lang('Categories') <i
                                    class="las la-file-invoice-dollar text--base"></i></h6>
                            <form class="search-form active">
                                <input type="text" name="search" class="form--control" value="{{ request()->search }}"
                                    placeholder="@lang('Search here')...">
                                <button type="submit" class="search-form__btn"><i class="las la-search"></i></button>
                            </form>
                        </div>

                        <table class="table table--responsive--lg">
                            <thead>
                                <tr>
                                    <th>@lang('Name')</th>
                                    <th>@lang('Foods')</th>
                                    <th>@lang('Status')</th>
                                    <th>@lang('Action')</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($categories as $category)
                                    <tr>
                                        <td>
                                            <span class="fw-bold"><span class="text--base">
                                                    {{ __(@$category->name) }}</span></span>
                                        </td>
                                        <td>
                                            {{ $category->foods_count }}
                                        </td>
                                        <td>
                                            @php echo $category->statusBadge @endphp
                                        </td>
                                        <td>

                                            <button class="btn btn--sm btn--base btn-outline--base editBtn"
                                                data-id="{{ $category->id }}" data-name="{{ $category->name }}">
                                                <i class="la la-pen"></i>
                                            </button>

                                            @if ($category->status == Status::DISABLE)
                                                <button class="btn btn--sm btn-outline--success ms-1 confirmationBtn"
                                                    data-question="@lang('Are you sure to enable this category?')"
                                                    data-action="{{ route('restaurant.category.status', $category->id) }}">
                                                    <i class="la la-eye"></i> @lang('Enable')
                                                </button>
                                            @else
                                                <button class="btn btn--sm btn-outline--danger ms-1 confirmationBtn"
                                                    data-question="@lang('Are you sure to disable this category?')"
                                                    data-action="{{ route('restaurant.category.status', $category->id) }}">
                                                    <i class="la la-eye-slash"></i> @lang('Disable')
                                                </button>
                                            @endif
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td class="text-muted empty-message" colspan="100%">{{ __($emptyMessage) }}</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div id="detailModal" class="modal fade" tabindex="-1" role="dialog">
        <div class="modal-dialog" role="document">
            <form id="myForm" method="POST">
                @csrf
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">@lang('Details')</h5>
                        <span type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                            <i class="las la-times"></i>
                        </span>
                    </div>
                    <div class="modal-body">
                        <div class="form-group">
                            <label class="form-label required">@lang('Name')</label>
                            <input type="text" class="form-control form--control" name="name" required>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn--base w-100">@lang('Submit')</button>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <x-confirmation-modal />
@endsection

@push('breadcrumb-plugins')
    <button class="btn btn--base addBtn">@lang('Add Category')</button>
@endpush

@push('script')
    <script>
        (function($) {
            "use strict";
            var url = '{{ route('restaurant.category.store') }}';
            $('.addBtn').on('click', function() {
                var modal = $('#detailModal');
                modal.find('form')[0].reset();
                $('#myForm').attr('action', url);
                modal.modal('show');
            });

            $('.editBtn').on('click', function() {
                var modal = $('#detailModal');
                modal.find('form')[0].reset();
                var categoryId = $(this).data('id');
                var categoryName = $(this).data('name');

                $('#myForm').attr('action', url + '/' + categoryId);
                $('input[name="name"]').val(categoryName);

                modal.modal('show');
            });
        })(jQuery);
    </script>
@endpush
