@extends($activeTemplate . 'layouts.frontend')

@section('content')
    @php
        $loginRegistration = getContent('login_registration.content', true);
    @endphp
    <div class="inner-banner-breadcrumbs">
        <div class="container">
            <div class="row justify-content-center">
                <ul class="breadcrumbs d-flex flex-wrap align-items-center justify-content-center">
                    <li><a href="{{ route('home') }}">@lang('Home')</a></li>
                    <li>{{ $pageTitle }}</li>
                </ul>
            </div>
        </div>
    </div>
    <section class="account section-bg-two pt-80 pb-80">
        <img class="account-shape-three"
            src="{{ frontendImage('login_registration', @$loginRegistration->data_values->image_one, '515x380') }}"
            alt="img not found" />
        <img class="account-shape-four"
            src="{{ frontendImage('login_registration', @$loginRegistration->data_values->image_two, '630x405') }}"
            alt="img not found" />
        <img class="account-shape-four-dark"
            src="{{ frontendImage('login_registration', @$loginRegistration->data_values->image_two_dark, '630x405') }}"
            alt="img not found" />
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-lg-6 col-md-10">
                    <div class="change-password">
                        <div class="signup-form">
                            <div class="signup-form-top text-center pb-30">
                                <div class="signup-page__content text-center">
                                    <h2>@lang('Login')</h2>
                                </div>
                            </div>

                            @include($activeTemplate . 'partials.social_login')

                            <form action="{{ route('restaurant.login') }}" method="POST" class="verify-gcaptcha">
                                @csrf
                                <div class="form-group">
                                    <div class="input-group">
                                        <input type="text" id="username" name="username" value="{{ old('username') }}"
                                            class="form-control form--control" placeholder="none" required />
                                        <label for="username" class="form-label">@lang('Username or Email')</label>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <div class="input-group">
                                        <input type="password" id="password" name="password"
                                            class="form-control form--control" placeholder="none" required />
                                        <label for="password" class="form-label mb-0">@lang('Password')</label>
                                    </div>
                                </div>

                                <div class="form-group d-flex flex-wrap justify-content-between">
                                    <div class="custom--checkbox">
                                        <input class="form-check-input" type="checkbox" name="remember" id="remember"
                                            {{ old('remember') ? 'checked' : '' }}>
                                        <label class="form-check-label" for="remember">@lang('Remember Me')</label>
                                    </div>
                                    <a href="{{ route('restaurant.password.request') }}" class="text--base forgot-pass">
                                        @lang('Forgot your password?')
                                    </a>
                                </div>

                                <x-captcha />

                                <div class="form-group">
                                    <button type="submit" id="recaptcha"
                                        class="btn btn--base w-100">@lang('Login')</button>
                                </div>
                                <p class="text-center heading-color mb-0">
                                    @lang('Don\'t have any account yet?')
                                    <a href="{{ route('restaurant.register') }}" class="text--base">@lang('Register')</a>
                                </p>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection
