@php
    $currentOrder = App\Models\Order::userOrders()
        ->whereIn('status', [Status::ORDER_PROCESSING, Status::ORDER_ON_DELIVERY])
        ->latest()
        ->first();

    if (request()->routeIs('restaurant.details')) {
        if (@$restaurant->id == @userInfo()['cart_restaurant_id']) {
            $cartUrl = 'javascript:void(0)';
        } else {
            $cartUrl = @userInfo()['cart_link'];
        }
    } else {
        $cartUrl = @userInfo()['cart_link'];
    }

    $cartCount = @userInfo()['cart_count'] ?? 0;
    $authenticatedUser = authenticatedUser();

@endphp

<div class="header-area">
    <div class="header-main" id="header-sticky">
        <div class="container custom-container">
            <div class="row align-items-center ">
                <div class="col-xl-2 col-lg-2 col-md-2 col-sm-3 col-12 d-flex justify-content-between">
                    <div class="logo">
                        <a href="{{ route('home') }}" class="logo-w"><img src="{{ siteLogo() }}" alt="logo-img"></a>
                    </div>
                    <div class="menu-bar d-sm-none">
                        <a class="side-toggle" href="javascript:void(0)">
                            <div class="bar-icon">
                                <span></span>
                                <span></span>
                                <span></span>
                            </div>
                        </a>
                    </div>
                </div>
                <div class="col-xl-4 col-lg-4  d-none d-xl-block">
                    <div class="main-menu-wrapper">
                        <div class="main-menu-inner d-flex align-items-center ">
                            <div class="menumain">
                                <nav id="mobile-menu">
                                    <ul>
                                        <li class="has-dropdown">
                                            <a class="link-item {{ menuActive('user.deposit.*') }}"
                                                href="javascript:void(0)">@lang('Deposit')</a>
                                            <ul class="submenu">
                                                <li><a href="{{ route('user.deposit.index') }}">@lang('Deposit Now')</a>
                                                </li>
                                                <li><a href="{{ route('user.deposit.history') }}">@lang('Deposit History')</a>
                                                </li>
                                            </ul>
                                        </li>

                                        <li class="has-dropdown">
                                            <a class="link-item {{ menuActive('user.withdraw*') }}"
                                                href="javascript:void(0)">@lang('Withdraw')</a>
                                            <ul class="submenu">
                                                <li><a href="{{ route('user.withdraw') }}">@lang('Withdraw Now')</a></li>
                                                <li><a href="{{ route('user.withdraw.history') }}">@lang('Withdraw History')</a>
                                                </li>
                                            </ul>
                                        </li>
                                        <li>
                                            <a class="link-item {{ menuActive('user.transactions') }}"
                                                href="{{ route('user.transactions') }}">@lang('Transactions')</a>
                                        </li>
                                    </ul>
                                </nav>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-xl-6 col-lg-10 col-md-10 col-sm-9 col-12 d-xl-block">
                    <div
                        class="header-area-right d-flex align-items-center justify-content-center justify-content-sm-end cart-menu-none">

                        @include($activeTemplate . 'partials.header.current_order')

                        @include($activeTemplate . 'partials.header.cart_favorite', [
                            'cartUrl' => $cartUrl,
                        ])

                        <div class="d-none d-lg-block">
                            <div class="header-area-right__featurs d-flex  align-items-center">
                                <div class="theme-switch-wrapper">
                                    <label class="theme-switch" for="checkbox2">
                                        <input type="checkbox" id="checkbox2" class="d-none">
                                        <span class="slider round"></span>
                                    </label>
                                </div>
                                @include($activeTemplate . 'partials.header.language_box')
                            </div>
                        </div>
                        <div class="nav-right-profile d-none d-lg-block">
                            <ul class="prfile-menu">
                                <li>
                                    @include($activeTemplate . 'partials.header.user_profile_dropdown', [
                                        'authenticatedUser' => $authenticatedUser,
                                    ])
                                </li>
                            </ul>
                        </div>
                        <div class="menu-bar menu-bar-sm  d-xl-none">
                            <a class="side-toggle" href="javascript:void(0)">
                                <div class="bar-icon">
                                    <span></span>
                                    <span></span>
                                    <span></span>
                                </div>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<div
    class="header-area-right d-flex align-items-center justify-content-center justify-content-sm-end cart-menu d-block d-sm-none ">
    @include($activeTemplate . 'partials.header.current_order_mobile_view')
    @include($activeTemplate . 'partials.header.cart_favorite', ['cartUrl' => $cartUrl])
</div>

@include($activeTemplate . 'partials.header.sidebar')
